//=============================================================================
// VisuStella MZ - Bright Effects
// VisuMZ_2_BrightEffects.js
//=============================================================================

var Imported = Imported || {};
Imported.VisuMZ_2_BrightEffects = true;

var VisuMZ = VisuMZ || {};
VisuMZ.BrightEffects = VisuMZ.BrightEffects || {};
VisuMZ.BrightEffects.version = 1.09;

//=============================================================================
 /*:
 * @target MZ
 * @plugindesc [RPG Maker MZ] [Tier 2] [Version 1.09] [BrightEffects]
 * @author VisuStella
 * @url http://www.yanfly.moe/wiki/Bright_Effects_VisuStella_MZ
 * @orderAfter VisuMZ_0_CoreEngine
 *
 * @help
 * ============================================================================
 * Introduction
 * ============================================================================
 * 
 * This RPG Maker MZ plugin allows you to add various bright effects to your
 * game's maps and battle system. These effects can make the game appear more
 * vivid, light, and gives you control over the color settings of a particular
 * map to make a more distinct feeling, too. The bright effects can be changed
 * midway through events in both maps and battles, too.
 *
 * Features include all (but not limited to) the following:
 * 
 * * A Bloom filter effect that can help soften the feel of a map by giving
 *   objects on the screen a slight hazy glow.
 * * Godrays can be used to show animated sunlight coming down from the sky
 *   above.
 * * The Color Adjustment filter allows you to alter the brightness, contrast,
 *   and saturation levels of your maps and battles.
 * * The Tilt Shift filter creates a blur at the top and bottom sections of the
 *   screen to give a sense of proximity blurring.
 * * Plugin Commands that allow you to adjust these settings on the go.
 * * Notetags for maps to alter the Bloom, Godray, and Color Adjustments
 *
 * ============================================================================
 * Requirements
 * ============================================================================
 *
 * This plugin is made for RPG Maker MZ. This will not work in other iterations
 * of RPG Maker.
 *
 * ------ Required Plugin List ------
 *
 * * Pixi JS Filters*
 *
 * This plugin requires the above listed plugins to be installed inside your
 * game's Plugin Manager list in order to work. You cannot start your game with
 * this plugin enabled without the listed plugins.
 * 
 * *Note* You can download the Pixi JS Filters plugin library from the below
 * URL or from the Action Sequence Impact product page. Install it as a
 * Tier 0 plugin.
 * 
 * *Note2* Pixi JS Filters perform differently on different machines/devices.
 * Please understand that this is outside of VisuStella's control.
 * 
 * URL: https://filters.pixijs.download/v3.1.0/pixi-filters.js
 *
 * ------ Tier 2 ------
 *
 * This plugin is a Tier 2 plugin. Place it under other plugins of lower tier
 * value on your Plugin Manager list (ie: 0, 1, 2, 3, 4, 5). This is to ensure
 * that your plugins will have the best compatibility with the rest of the
 * VisuStella MZ library.
 *
 * ============================================================================
 * New Effects
 * ============================================================================
 *
 * This plugin adds some new hard-coded features to RPG Maker MZ's functions.
 * The following is a list of them.
 *
 * ---
 *
 * Bloom
 * 
 * This filter puts a faint (or large) glow around lighter-colored objects on
 * the map to give them a softer, hazy, brighter feeling.
 * 
 * Properties:
 *
 * Scale: To adjust the strength of the bloom. Higher values is more
 * intense brightness.
 *
 * Brightness: The brightness, lower value is more subtle brightness, higher
 * value is blown-out.
 *
 * Threshold: Defines how bright a color needs to be to affect bloom.
 *
 * ---
 * 
 * Blur
 * 
 * The blur filter makes the screen appear less focused and more fuzzy. Details
 * become harder to distinguish and the like.
 * 
 * Properties:
 * 
 * Blur: Adjusts the blur strength. For best results, use numbers between 0 and
 * 5 where 0 is no blur and higher numbers mean higher blur strength. There are
 * no default Plugin Parameter settings for the Blur strength as it will
 * automatically default to 0 for best results.
 * 
 * ---
 *
 * Godray
 * 
 * The Godray filter puts down rays of light coming from the sky at an angle.
 * This is often used to represent sunlight peaking from above the clouds.
 * 
 * Properties:
 *
 * Visible: If on, the godrays will be visible by default. If off, they won't.
 *
 * Speed: The speed at which the light flickers. Lower for slower rate.
 * Higher for faster speeds.
 *
 * Gain: General intensity of the effect.
 *
 * Lacunarity: The density of the fractal noise.
 *
 * Angle: The angle/light-source direction of the rays.
 *
 * ---
 *
 * Color Adjustment
 * 
 * The Color Adjustment filter allows you to control the colors on the screen
 * to be more/less bright, contrast more/less, and more/less saturated.
 * 
 * Properties:
 *
 * Brightness: Adjusts the overall brightness of the screen. Use lower numbers
 * to make it darker and higher numbers to increase the brightness.
 *
 * Contrast: Increases the separation between dark and bright. Darker colors
 * become darker. Lighter colors become lighter. Increase this number to make
 * the effect more intense or decrease it to lessen it.
 *
 * Saturate: Adjusts the intensity of color on the screen. User higher numbers
 * to make colors more intense and lower numbers to make it less.
 *
 * ---
 * 
 * Tilt Shift
 * 
 * The Tilt Shift filter creates a blur at the upper and lower edges of the
 * screen with varying degrees of pixelation blur and gradient blur.
 * 
 * Properties:
 * 
 * Pixel Blur: What is the default pixel blur amount for tilt shift? Smaller
 * values mean less blur. Higher values mean more blur.
 * 
 * Gradient Blur: What is the default gradient blur amount for tilt shift?
 * Smaller values mean less gradient. Higher values mean more gradient.
 * 
 * ---
 *
 * ============================================================================
 * Extra Features
 * ============================================================================
 *
 * There are some extra features found if other VisuStella MZ plugins are found
 * present in the Plugin Manager list.
 *
 * ---
 * 
 * VisuMZ_1_OptionsCore
 * 
 * As of the VisuStella MZ Options Core v1.10 update, both the Bright Effects
 * and Horror Effects plugins will be affected by the "Special Effects" option
 * found under the Options Core's General Settings. If the "Special Effects"
 * option is set to OFF, then the filter effects applied by those plugins will
 * also be disabled. They will be reenabled when the option is set back to ON.
 * 
 * ---
 *
 * ============================================================================
 * Notetags
 * ============================================================================
 *
 * The following are notetags that have been added through this plugin. These
 * notetags will not work with your game if this plugin is OFF or not present.
 *
 * ---
 * 
 * === Bloom-Related Notetags ===
 * 
 * ---
 *
 * <Bloom Scale: x>
 *
 * - Used for: Map Notetags and Troop Names
 * - Changes the bloom scale to x for map/battle.
 * - Replace 'x' with a number to represent the value. Use decimals.
 *   - Lower - Less bloom
 *   - Higher - More bloom
 *
 * ---
 *
 * <Bloom Brightness: x>
 *
 * - Used for: Map Notetags and Troop Names
 * - Changes the bloom brightness to x for map/battle
 * - Replace 'x' with a number to represent the value. Use decimals.
 *   - Lower - Darker
 *   - Higher - Brighter
 *
 * ---
 *
 * <Bloom Threshold: x>
 *
 * - Used for: Map Notetags and Troop Names
 * - Changes the bloom threshold to x for map/battle.
 * - Replace 'x' with a number to represent the value. Use decimals.
 *   - Lower - Less picky
 *   - Higher - More picky
 *
 * ---
 *
 * <Bloom Horz Scale: x to y>
 * <Bloom Vert Scale: x to y>
 *
 * - Used for: Map Notetags
 * - Map only. Sets an adjusting scale when traveling left to right on the map
 *   (Horz) or up to down on the map (Vert).
 * - Replace 'x' and 'y' with numbers to represent the value. Use decimals.
 *   - Lower - Less bloom
 *   - Higher - More bloom
 *
 * ---
 *
 * <Bloom Horz Brightness: x to y>
 * <Bloom Vert Brightness: x to y>
 *
 * - Used for: Map Notetags
 * - Map only. Sets an adjusting brightness when traveling left to right on the
 *   map (Horz) or up to down on the map (Vert).
 * - Replace 'x' and 'y' with numbers to represent the value. Use decimals.
 *   - Lower - Darker
 *   - Higher - Brighter
 *
 * ---
 *
 * <Bloom Horz Threshold: x to y>
 * <Bloom Vert Threshold: x to y>
 *
 * - Used for: Map Notetags
 * - Map only. Sets an adjusting threshold when traveling left to right on the
 *   map (Horz) or up to down on the map (Vert).
 * - Replace 'x' and 'y' with numbers to represent the value. Use decimals.
 *   - Lower - Less picky
 *   - Higher - More picky
 *
 * ---
 * 
 * === Blur-Related Notetags ===
 * 
 * ---
 * 
 * <Blur: x>
 * 
 * - Used for: Map Notetags and Troop Names
 * - Changes the blur strength used for the screen to 'x'.
 * - Replace 'x' with a number representing the blur strength. For best
 *   results, use numbers between 0 and 5 where 0 is no blur and higher numbers
 *   mean higher blur strength.
 * 
 * ---
 * 
 * === Godray-Related Notetags ===
 * 
 * ---
 *
 * <Godray>
 * <No Godray>
 *
 * - Used for: Map Notetags and Troop Names
 * - Changes if there will be a godray on the map/battle regardless of the
 *   default settings in the plugin parameters.
 *
 * ---
 *
 * <Godray Speed: x>
 *
 * - Used for: Map Notetags and Troop Names
 * - Sets the flickering speed of the rays.
 * - Replace 'x' with a number to represent the value. Use decimals.
 *   - Lower - Slower
 *   - Higher - Faster
 *
 * ---
 *
 * <Godray Gain: x>
 *
 * - Used for: Map Notetags and Troop Names
 * - Sets the gain/intensity of the rays.
 * - Replace 'x' with a number to represent the value. Use decimals.
 *   - Lower - Lighter
 *   - Higher - Intense
 *
 * ---
 *
 * <Godray Lacunarity: x>
 *
 * - Used for: Map Notetags and Troop Names
 * - Sets the lacunarity/density of the rays.
 * - Replace 'x' with a number to represent the value. Use decimals.
 *   - Lower - Less dense
 *   - Higher - More dense
 *
 * ---
 *
 * <Godray Angle: x>
 *
 * - Used for: Map Notetags and Troop Names
 * - Sets the angle of the rays.
 * - Replace 'x' with a number to represent the value. Use a negative or
 *   positive integer value.
 *   - Negative - Coming from the left
 *   - Positive - Coming from the right
 *
 * ---
 *
 * <Godray Horz Speed: x to y>
 * <Godray Vert Speed: x to y>
 *
 * - Used for: Map Notetags
 * - Map only. Adjusts godray speed going left to right on a map (Horz) or up
 *   to down on a map (Vert). 
 * - Replace 'x' and 'y' with numbers to represent the value. Use decimals.
 *   - Lower - Slower
 *   - Higher - Faster
 *
 * ---
 *
 * <Godray Horz Gain: x to y>
 * <Godray Vert Gain: x to y>
 *
 * - Used for: Map Notetags
 * - Map only. Adjusts godray gain going left to right on a map (Horz) or up to
 *   down on a map (Vert).
 * - Replace 'x' and 'y' with numbers to represent the value. Use decimals.
 *   - Lower - Lighter
 *   - Higher - Intense
 *
 * ---
 *
 * <Godray Horz Lacunarity: x to y>
 * <Godray Vert Lacunarity: x to y>
 *
 * - Used for: Map Notetags
 * - Map only. Adjusts godray lacunarity going left to right on a map (Horz) or
 *   up to down on a map (Vert).
 * - Replace 'x' and 'y' with numbers to represent the value. Use decimals.
 *   - Lower - Less dense
 *   - Higher - More dense
 *
 * ---
 *
 * <Godray Horz Angle: x to y>
 * <Godray Vert Angle: x to y>
 *
 * - Used for: Map Notetags
 * - Map only. Adjusts godray angle going left to right on a map (Horz) or up
 *   to down on a map (Vert).
 * - Replace 'x' and 'y' with numbers to represent the value. Use a negative or
 *   positive integer values.
 *   - Negative - Coming from the left
 *   - Positive - Coming from the right
 *
 * ---
 * 
 * === Color Adjust-Related Notetags ===
 * 
 * ---
 *
 * <Color Adjust Brightness: x>
 *
 * - Used for: Map Notetags and Troop Names
 * - Alters the screen brightness for the map/battle.
 * - Replace 'x' with a number to represent the value. Use decimals.
 *   - Lower - Darker
 *   - Higher - Brighter
 *
 * ---
 *
 * <Color Adjust Contrast: x>
 *
 * - Used for: Map Notetags and Troop Names
 * - Adjusts the screen contrast for the map/battle.
 * - Replace 'x' with a number to represent the value. Use decimals.
 *   - Lower - Less contrast
 *   - Higher - More contrast
 *
 * ---
 *
 * <Color Adjust Saturate: x>
 *
 * - Used for: Map Notetags and Troop Names
 * - Adjusts the screen saturation for the map/battle.
 * - Replace 'x' with a number to represent the value. Use decimals.
 *   - Lower - Darker
 *   - Higher - Brighter
 *
 * ---
 *
 * <Color Adjust Horz Brightness: x to y>
 * <Color Adjust Vert Brightness: x to y>
 *
 * - Used for: Map Notetags
 * - Map only. Alters the screen brightness when moving left to right on a map
 *   (Horz) or up to down on a map (Vert).
 * - Replace 'x' and 'y' with numbers to represent the value. Use decimals.
 *   - Lower - Darker
 *   - Higher - Brighter
 *
 * ---
 *
 * <Color Adjust Horz Contrast: x to y>
 * <Color Adjust Vert Contrast: x to y>
 *
 * - Used for: Map Notetags
 * - Map only. Adjusts the screen contrast when moving left to right on a map
 *   (Horz) or up to down on a map (Vert).
 * - Replace 'x' and 'y' with numbers to represent the value. Use decimals.
 *   - Lower - Less contrast
 *   - Higher - More contrast
 *
 * ---
 *
 * <Color Adjust Horz Saturate: x to y>
 * <Color Adjust Vert Saturate: x to y>
 *
 * - Used for: Map Notetags
 * - Map only. Adjusts the screen saturation when moving left to right on a map
 *   (Horz) or up to down on a map (Vert).
 * - Replace 'x' and 'y' with numbers to represent the value. Use decimals.
 *   - Lower - Less intensity
 *   - Higher - More intensity
 *
 * ---
 * 
 * === Tilt Shift Notetags ===
 * 
 * ---
 * 
 * <Tilt Shift Pixel Blur: x>
 * 
 * - Used for: Map Notetags and Troop Names
 * - Adjusts the tilt shift filter's pixel blur amount for the map/battle.
 * - Replace 'x' with a number to represent the blur intensity.
 *   - Lower = less blur
 *   - Higher = more blur
 * 
 * ---
 * 
 * <Tilt Shift Gradient Blur: x>
 * 
 * - Used for: Map Notetags and Troop Names
 * - Adjusts the tilt shift filter's gradient blur amount for the map/battle.
 * - Replace 'x' with a number to represent the gradient blur distance.
 *   - Lower = less gradient
 *   - Higher = more gradient
 * 
 * ---
 *
 * ============================================================================
 * Plugin Commands
 * ============================================================================
 *
 * The following are Plugin Commands that come with this plugin. They can be
 * accessed through the Plugin Command event command.
 *
 * ---
 * 
 * === Bloom Plugin Commands ===
 * 
 * ---
 *
 * Bloom: Change Settings
 * - Change the Bloom filter settings for the screen.
 *
 *   Bloom Scale:
 *   - Change bloom scale for the screen.
 *
 *   Bloom Brightness:
 *   - Change bloom brightness for the screen.
 *
 *   Bloom Threshold:
 *   - Change bloom threshold for the screen.
 *
 *   Shift Duration:
 *   - The amount of time it takes for the change to occur.
 *
 * ---
 *
 * Bloom: Reset
 * - Reset the Bloom filter settings for the settings found in the Plugin
 *   Parameters or map notetags.
 *
 *   Shift Duration:
 *   - The amount of time it takes for the reset to occur.
 *
 * ---
 * 
 * === Blur Plugin Commands ===
 * 
 * ---
 * 
 * Blur: Change Settings
 * - Change the Blur filter settings for the screen.
 * 
 *   Blur Strength:
 *   - Change blur strength for the screen.
 *   - For best results, use numbers between 0 and 5  where 0 is no blur and
 *     higher numbers mean higher blur strength.
 * 
 *   Blur Duration:
 *   - The amount of time it takes for the change to occur.
 * 
 * ---
 * 
 * Blur: Reset
 * - Clears the Blur filter.
 * 
 *   Blur Duration:
 *   - The amount of time it takes for the reset to occur.
 * 
 * ---
 * 
 * === Godray Plugin Commands ===
 * 
 * ---
 *
 * Godray: Change Settings
 * - Change the Godray filter settings for the screen.
 *
 *   Visible?:
 *   - Show godrays on the screen?
 *   - Visibility changes are immediate.
 *
 *   Godray Speed:
 *   - Change godray speed for the screen.
 *
 *   Godray Gain:
 *   - Change godray gain for the screen.
 *
 *   Godray Lacunarity:
 *   - Change godray lacunarity for the screen.
 *
 *   Godray Angle:
 *   - Change godray angle for the screen.
 *
 *   Shift Duration:
 *   - The amount of time it takes for the change to occur.
 *   - Visibility changes are immediate.
 *
 * ---
 *
 * Godray: Reset
 * - Reset the Godray filter settings for the settings found in the Plugin
 *   Parameters or map notetags.
 *
 *   Shift Duration:
 *   - The amount of time it takes for the reset to occur.
 *   - Visibility changes are immediate.
 *
 * ---
 * 
 * === Color Adjust Plugin Commands ===
 * 
 * ---
 *
 * Color Adjust: Change Settings
 * - Change the Color Adjustment filter settings for the screen.
 *
 *   Adjust Brightness:
 *   - Change color adjust brightness for the screen.
 *
 *   Adjust Contrast:
 *   - Change color adjust contrast for the screen.
 *
 *   Adjust Saturation:
 *   - Change color adjust saturation for the screen.
 *
 *   Shift Duration:
 *   - The amount of time it takes for the change to occur.
 *
 * ---
 *
 * Color Adjust: Reset
 * - Reset the Color Adjustment filter settings for the settings found in the
 *   Plugin Parameters or map notetags.
 *
 *   Shift Duration:
 *   - The amount of time it takes for the reset to occur.
 *
 * ---
 * 
 * === Tilt Shift Plugin Commands ===
 * 
 * ---
 * 
 * Tilt Shift: Change Settings
 * - Change the Tilt Shift filter settings for the screen.
 * 
 *   Pixel Blur:
 *   - What is the default pixel blur amount for tilt shift?
 *   - Smaller = less blur. Higher = more blur.
 * 
 *   Gradient Blur:
 *   - What is the default gradient blur amount for tilt shift?
 *   - Smaller = less gradient. Higher = more gradient.
 * 
 *   Shift Duration:
 *   - The amount of time it takes for the change to occur.
 * 
 * ---
 * 
 * Tilt Shift: Reset
 * - Reset the Tilt Shift filter settings for the settings found in the
 *   Plugin Parameters or map notetags.
 * 
 *   Shift Duration:
 *   - The amount of time it takes for the change to occur.
 * 
 * ---
 * 
 * ============================================================================
 * Plugin Parameters: General Settings
 * ============================================================================
 * 
 * This section is for the general plugin parameter settings.
 * 
 * ---
 * 
 * General
 * 
 *   Apply Base-Only?
 *   - Base-Only excludes pictures, timers, and weather.
 *   - Whole includes the above.
 * 
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Bloom Settings
 * ============================================================================
 *
 * There are two versions of these plugin parameters. One of them are for the
 * Map Defaults and the other is for the Battle Defaults. These settings are
 * applied to the map and battle scenes respectively and will serve as the
 * stock setting when no map notetags, troop name tags, or Plugin Commands have
 * been used to alter them.
 *
 * ---
 *
 * Bloom Settings
 * 
 *   Bloom Scale:
 *   - Default bloom scale for the screen unless changed through tags.
 * 
 *   Bloom Brightness:
 *   - Default bloom brightness for the screen unless changed through tags.
 * 
 *   Bloom Threshold:
 *   - Default bloom threshold for the screen unless changed through tags.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Godray Settings
 * ============================================================================
 *
 * There are two versions of these plugin parameters. One of them are for the
 * Map Defaults and the other is for the Battle Defaults. These settings are
 * applied to the map and battle scenes respectively and will serve as the
 * stock setting when no map notetags, troop name tags, or Plugin Commands have
 * been used to alter them.
 *
 * ---
 *
 * Godray Settings
 * 
 *   Default Visible?:
 *   - Show godrays on all screens by default unless changed through tags?
 * 
 *   Godray Speed:
 *   - Default godray speed for all screens unless changed through tags.
 * 
 *   Godray Gain:
 *   - Default godray gain for all screens unless changed through tags.
 * 
 *   Godray Lacunarity:
 *   - Default godray lacunarity for all screens unless changed through tags.
 * 
 *   Godray Angle:
 *   - Default godray angle for all screens unless changed through tags.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Color Adjust Settings
 * ============================================================================
 *
 * There are two versions of these plugin parameters. One of them are for the
 * Map Defaults and the other is for the Battle Defaults. These settings are
 * applied to the map and battle scenes respectively and will serve as the
 * stock setting when no map notetags, troop name tags, or Plugin Commands have
 * been used to alter them.
 *
 * ---
 *
 * Color Adjust Settings
 * 
 *   Adjust Brightness:
 *   - Default color adjust brightness for all screens unless changed
 *     through tags.
 * 
 *   Adjust Contrast:
 *   - Default color adjust contrast for all screens unless changed
 *     through tags.
 * 
 *   Adjust Saturation:
 *   - Default color adjust saturation for all screens unless changed
 *     through tags.
 *
 * ---
 *
 * ============================================================================
 * Plugin Parameters: Tilt Shift Settings
 * ============================================================================
 *
 * There are two versions of these plugin parameters. One of them are for the
 * Map Defaults and the other is for the Battle Defaults. These settings are
 * applied to the map and battle scenes respectively and will serve as the
 * stock setting when no map notetags, troop name tags, or Plugin Commands have
 * been used to alter them.
 *
 * ---
 *
 * Tilt Shift Settings
 * 
 *   Pixel Blur:
 *   - What is the default pixel blur amount for tilt shift?
 *   - Smaller = less blur. Higher = more blur.
 * 
 *   Gradient Blur:
 *   - What is the default gradient blur amount for tilt shift?
 *   - Smaller = less gradient. Higher = more gradient.
 *
 * ---
 *
 * ============================================================================
 * Terms of Use
 * ============================================================================
 *
 * 1. These plugins may be used in free or commercial games provided that they
 * have been acquired through legitimate means at VisuStella.com and/or any
 * other official approved VisuStella sources. Exceptions and special
 * circumstances that may prohibit usage will be listed on VisuStella.com.
 * 
 * 2. All of the listed coders found in the Credits section of this plugin must
 * be given credit in your games or credited as a collective under the name:
 * "VisuStella".
 * 
 * 3. You may edit the source code to suit your needs, so long as you do not
 * claim the source code belongs to you. VisuStella also does not take
 * responsibility for the plugin if any changes have been made to the plugin's
 * code, nor does VisuStella take responsibility for user-provided custom code
 * used for custom control effects including advanced JavaScript notetags
 * and/or plugin parameters that allow custom JavaScript code.
 * 
 * 4. You may NOT redistribute these plugins nor take code from this plugin to
 * use as your own. These plugins and their code are only to be downloaded from
 * VisuStella.com and other official/approved VisuStella sources. A list of
 * official/approved sources can also be found on VisuStella.com.
 *
 * 5. VisuStella is not responsible for problems found in your game due to
 * unintended usage, incompatibility problems with plugins outside of the
 * VisuStella MZ library, plugin versions that aren't up to date, nor
 * responsible for the proper working of compatibility patches made by any
 * third parties. VisuStella is not responsible for errors caused by any
 * user-provided custom code used for custom control effects including advanced
 * JavaScript notetags and/or plugin parameters that allow JavaScript code.
 *
 * 6. If a compatibility patch needs to be made through a third party that is
 * unaffiliated with VisuStella that involves using code from the VisuStella MZ
 * library, contact must be made with a member from VisuStella and have it
 * approved. The patch would be placed on VisuStella.com as a free download
 * to the public. Such patches cannot be sold for monetary gain, including
 * commissions, crowdfunding, and/or donations.
 * 
 * 7. If this VisuStella MZ plugin is a paid product, all project team members
 * must purchase their own individual copies of the paid product if they are to
 * use it. Usage includes working on related game mechanics, managing related
 * code, and/or using related Plugin Commands and features. Redistribution of
 * the plugin and/or its code to other members of the team is NOT allowed
 * unless they own the plugin itself as that conflicts with Article 4.
 * 
 * 8. Any extensions and/or addendums made to this plugin's Terms of Use can be
 * found on VisuStella.com and must be followed.
 *
 * ============================================================================
 * Credits
 * ============================================================================
 * 
 * If you are using this plugin, credit the following people in your game:
 * 
 * Team VisuStella
 * * Yanfly
 * * Arisu
 * * Olivia
 * * Irina
 *
 * ============================================================================
 * Changelog
 * ============================================================================
 * 
 * Version 1.09: October 17, 2024
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.08: June 13, 2024
 * * Bug Fixes!
 * ** Added a failsafe to prevent crashes when no focus target is found due to
 *    either changing map or a sprite is deleted. Fix made by Olivia.
 * 
 * Version 1.07: March 16, 2023
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New features added by Olivia and sponsored by Archeia:
 * *** Blur
 * **** The blur filter makes the screen appear less focused and more fuzzy.
 *      Details become harder to distinguish and the like.
 * **** Notetags and Plugin Commands added.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.06: October 13, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features!
 * ** New features added by Olivia and sponsored by Archeia:
 * *** Tilt Shift
 * **** The Tilt Shift filter creates a blur at the upper and lower edges of
 *      the screen with varying degrees of pixelation blur and gradient blur.
 * **** Plugin Parameters, Notetags, and Plugin Commands added.
 * * Optimization Update!
 * ** Plugin should run more optimized.
 * 
 * Version 1.05: April 28, 2022
 * * Bug Fixes!
 * ** No longer crashes with event test play. Fix made by Olivia.
 * 
 * Version 1.04: March 24, 2022
 * * Documentation Update!
 * ** Help file updated for new features.
 * * New Features:
 * ** New Plugin Parameters added: "Apply Base-Only?"
 * *** Base-Only excludes pictures, timers, and weather.
 * *** Whole includes the above.
 * 
 * Version 1.03: April 2, 2021
 * * Bug Fixes!
 * ** Changing scenes while a filter change is in transition will automatically
 *    load up the changes made to the filter to prevent desynchronization.
 *    Fix made by Olivia.
 * 
 * Version 1.02: March 12, 2021
 * * Compatibility Update!
 * ** Added compatibility with the VisuStella MZ Options Core v1.10 update.
 * *** When the "Special Effects" option is set to OFF, the filters for this
 *     plugin will be shut off. They will be returned to normal when set to ON.
 * * Documentation Update!
 * ** Added the Options Core section to the "Extra Features" list.
 * 
 * Version 1.01: December 25, 2020
 * * Bug Fixes!
 * ** Bright effects from battle should no longer carry back over into the
 *    map scene. Fix made by Yanfly.
 *
 * Version 1.00: January 18, 2021
 * * Finished Plugin!
 *
 * ============================================================================
 * End of Helpfile
 * ============================================================================
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Begin
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command BloomChange
 * @text Bloom: Change Settings
 * @desc Change the Bloom filter settings for the screen.
 *
 * @arg Scale:num
 * @text Bloom Scale
 * @desc Change bloom scale for the screen.
 * @default 0.5
 *
 * @arg Brightness:num
 * @text Bloom Brightness
 * @desc Change bloom brightness for the screen.
 * @default 1.0
 *
 * @arg Threshold:num
 * @text Bloom Threshold
 * @desc Change bloom threshold for the screen.
 * @default 0.5
 *
 * @arg Duration:num
 * @text Shift Duration
 * @type number
 * @desc The amount of time it takes for the change to occur.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command BloomReset
 * @text Bloom: Reset
 * @desc Reset the Bloom filter settings for the settings found in
 * the Plugin Parameters or map notetags.
 *
 * @arg Duration:num
 * @text Shift Duration
 * @type number
 * @desc The amount of time it takes for the reset to occur.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Blur
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command BlurChange
 * @text Blur: Change Settings
 * @desc Change the Blur filter settings for the screen.
 *
 * @arg Blur:num
 * @text Blur Strength
 * @desc Change blur strength for the screen.
 * For best results, use numbers between 0 and 5.
 * @default 2.0
 *
 * @arg Duration:num
 * @text Blur Duration
 * @type number
 * @desc The amount of time it takes for the change to occur.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command BlurReset
 * @text Blur: Reset
 * @desc Clears the Blur filter.
 *
 * @arg Duration:num
 * @text Blur Duration
 * @type number
 * @desc The amount of time it takes for the reset to occur.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_Godray
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command GodrayChange
 * @text Godray: Change Settings
 * @desc Change the Godray filter settings for the screen.
 *
 * @arg Visible:eval
 * @text Visible?
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show godrays on the screen?
 * Visibility changes are immediate.
 * @default true
 *
 * @arg Speed:num
 * @text Godray Speed
 * @desc Change godray speed for the screen.
 * @default 0.01
 *
 * @arg Gain:num
 * @text Godray Gain
 * @desc Change godray gain for the screen.
 * @default 0.6
 *
 * @arg Lacunarity:num
 * @text Godray Lacunarity
 * @desc Change godray lacunarity for the screen.
 * @default 2.0
 *
 * @arg Angle:num
 * @text Godray Angle
 * @desc Change godray angle for the screen.
 * @default -30
 *
 * @arg Duration:num
 * @text Shift Duration
 * @type number
 * @desc The amount of time it takes for the change to occur.
 * Visibility changes are immediate.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command GodrayReset
 * @text Godray: Reset
 * @desc Reset the Godray filter settings for the settings
 * found in the Plugin Parameters or map notetags.
 *
 * @arg Duration:num
 * @text Shift Duration
 * @type number
 * @desc The amount of time it takes for the reset to occur.
 * Visibility changes are immediate.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_ColorAdjust
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ColorAdjustChange
 * @text Color Adjust: Change Settings
 * @desc Change the Color Adjustment filter settings for the screen.
 *
 * @arg Brightness:num
 * @text Adjust Brightness
 * @desc Change color adjust brightness for the screen.
 * @default 1.0
 *
 * @arg Contrast:num
 * @text Adjust Contrast
 * @desc Change color adjust contrast for the screen.
 * @default 0.0
 *
 * @arg Saturate:num
 * @text Adjust Saturation
 * @desc Change color adjust saturation for the screen.
 * @default 0.0
 *
 * @arg Duration:num
 * @text Shift Duration
 * @type number
 * @desc The amount of time it takes for the change to occur.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command ColorAdjustReset
 * @text Color Adjust: Reset
 * @desc Reset the Color Adjustment filter settings for the settings
 * found in the Plugin Parameters or map notetags.
 *
 * @arg Duration:num
 * @text Shift Duration
 * @type number
 * @desc The amount of time it takes for the reset to occur.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_TiltShift
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @command TiltShiftChange
 * @text Tilt Shift: Change Settings
 * @desc Change the Tilt Shift filter settings for the screen.
 *
 * @arg Blur:num
 * @text Pixel Blur
 * @desc What is the default pixel blur amount for tilt shift?
 * Smaller = less blur. Higher = more blur.
 * @default 24
 *
 * @arg GradientBlur:num
 * @text Gradient Blur
 * @desc What is the default gradient blur amount for tilt shift?
 * Smaller = less gradient. Higher = more gradient.
 * @default 1000
 *
 * @arg Duration:num
 * @text Shift Duration
 * @type number
 * @desc The amount of time it takes for the change to occur.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command TiltShiftReset
 * @text Tilt Shift: Reset
 * @desc Reset the Tilt Shift filter settings for the settings
 * found in the Plugin Parameters or map notetags.
 *
 * @arg Duration:num
 * @text Shift Duration
 * @type number
 * @desc The amount of time it takes for the reset to occur.
 * @default 60
 *
 * @ --------------------------------------------------------------------------
 *
 * @command Separator_End
 * @text -
 * @desc -
 *
 * @ --------------------------------------------------------------------------
 *
 * @ ==========================================================================
 * @ Plugin Parameters
 * @ ==========================================================================
 *
 * @param BreakHead
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param BrightEffects
 * @default Plugin Parameters
 *
 * @param ATTENTION
 * @default READ THE HELP FILE
 *
 * @param BreakSettings
 * @text --------------------------
 * @default ----------------------------------
 * 
 * @param Map
 * @text Map Defaults
 *
 * @param MapBaseFilter:eval
 * @text Apply Base-Only?
 * @parent Map
 * @type boolean
 * @on Base-Only
 * @off Apply Whole
 * @desc Base-Only excludes pictures, timers, and weather.
 * Whole includes the above.
 * @default true
 *
 * @param MapBloom:struct
 * @text Bloom Settings
 * @parent Map
 * @type struct<Bloom>
 * @desc Default bloom settings for all maps.
 * @default {"Scale:num":"0.5","Brightness:num":"1.0","Threshold:num":"0.5"}
 *
 * @param MapGodray:struct
 * @text Godray Settings
 * @parent Map
 * @type struct<Godray>
 * @desc Default Godray settings for all maps.
 * @default {"Visible:eval":"false","Speed:num":"0.01","Gain:num":"0.6","Lacunarity:num":"2.0","Angle:num":"-30"}
 *
 * @param MapColorAdjust:struct
 * @text Color Adjust Settings
 * @parent Map
 * @type struct<ColorAdjust>
 * @desc Default color adjustment settings for all maps.
 * @default {"Brightness:num":"1.0","Contrast:num":"0.0","Saturate:num":"0.0"}
 *
 * @param MapTiltShift:struct
 * @text Tilt Shift Settings
 * @parent Map
 * @type struct<TiltShift>
 * @desc Default tilt shift adjustment settings for all maps.
 * @default {"Blur:num":"24","GradientBlur:num":"1000"}
 * 
 * @param Battle
 * @text Battle Defaults
 *
 * @param BattleBaseFilter:eval
 * @text Apply Base-Only?
 * @parent Battle
 * @type boolean
 * @on Base-Only
 * @off Apply Whole
 * @desc Base-Only excludes pictures, timers, and weather.
 * Whole includes the above.
 * @default true
 *
 * @param BattleBloom:struct
 * @text Bloom Settings
 * @parent Battle
 * @type struct<Bloom>
 * @desc Default bloom settings for all battles.
 * @default {"Scale:num":"0.5","Brightness:num":"1.0","Threshold:num":"0.5"}
 *
 * @param BattleGodray:struct
 * @text Godray Settings
 * @parent Battle
 * @type struct<Godray>
 * @desc Default Godray settings for all battles.
 * @default {"Visible:eval":"false","Speed:num":"0.01","Gain:num":"0.6","Lacunarity:num":"2.0","Angle:num":"-30"}
 *
 * @param BattleColorAdjust:struct
 * @text Color Adjust Settings
 * @parent Battle
 * @type struct<ColorAdjust>
 * @desc Default color adjustment settings for all battles.
 * @default {"Brightness:num":"1.0","Contrast:num":"0.0","Saturate:num":"0.0"}
 *
 * @param BattleTiltShift:struct
 * @text Tilt Shift Settings
 * @parent Battle
 * @type struct<TiltShift>
 * @desc Default tilt shift adjustment settings for all battles.
 * @default {"Blur:num":"0","GradientBlur:num":"1600"}
 *
 * @param BreakEnd1
 * @text --------------------------
 * @default ----------------------------------
 *
 * @param End Of
 * @default Plugin Parameters
 *
 * @param BreakEnd2
 * @text --------------------------
 * @default ----------------------------------
 *
 */
/* ----------------------------------------------------------------------------
 * Bloom Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Bloom:
 *
 * @param Scale:num
 * @text Bloom Scale
 * @desc Default bloom scale for the screen unless changed through tags.
 * @default 0.5
 *
 * @param Brightness:num
 * @text Bloom Brightness
 * @desc Default bloom brightness for the screen unless changed through tags.
 * @default 1.0
 *
 * @param Threshold:num
 * @text Bloom Threshold
 * @desc Default bloom threshold for the screen unless changed through tags.
 * @default 0.5
 *
 */
/* ----------------------------------------------------------------------------
 * Godray Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~Godray:
 *
 * @param Visible:eval
 * @text Default Visible?
 * @type boolean
 * @on Show
 * @off Hide
 * @desc Show godrays on all screens by default unless changed through tags?
 * @default false
 *
 * @param Speed:num
 * @text Godray Speed
 * @desc Default godray speed for all screens unless changed through tags.
 * @default 0.01
 *
 * @param Gain:num
 * @text Godray Gain
 * @desc Default godray gain for all screens unless changed through tags.
 * @default 0.6
 *
 * @param Lacunarity:num
 * @text Godray Lacunarity
 * @desc Default godray lacunarity for all screens unless changed through tags.
 * @default 2.0
 *
 * @param Angle:num
 * @text Godray Angle
 * @desc Default godray angle for all screens unless changed through tags.
 * @default -30
 *
 */
/* ----------------------------------------------------------------------------
 * Color Adjust Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~ColorAdjust:
 *
 * @param Brightness:num
 * @text Adjust Brightness
 * @desc Default color adjust brightness for all screens unless changed through tags.
 * @default 1.0
 *
 * @param Contrast:num
 * @text Adjust Contrast
 * @desc Default color adjust contrast for all screens unless changed through tags.
 * @default 0.0
 *
 * @param Saturate:num
 * @text Adjust Saturation
 * @desc Default color adjust saturation for all screens unless changed through tags.
 * @default 0.0
 *
 */
/* ----------------------------------------------------------------------------
 * Tilt Shift Settings
 * ----------------------------------------------------------------------------
 */
/*~struct~TiltShift:
 *
 * @param Blur:num
 * @text Pixel Blur
 * @desc What is the default pixel blur amount for tilt shift?
 * Smaller = less blur. Higher = more blur.
 * @default 24
 *
 * @param GradientBlur:num
 * @text Gradient Blur
 * @desc What is the default gradient blur amount for tilt shift?
 * Smaller = less gradient. Higher = more gradient.
 * @default 1000
 *
 */
//=============================================================================

function _0xd73b(_0x1203f7,_0x1bd2b1){var _0x1bb49e=_0x1bb4();return _0xd73b=function(_0xd73b6d,_0x3438eb){_0xd73b6d=_0xd73b6d-0x1d3;var _0x3b7a73=_0x1bb49e[_0xd73b6d];return _0x3b7a73;},_0xd73b(_0x1203f7,_0x1bd2b1);}var _0x344e4d=_0xd73b;(function(_0x5cf1a9,_0x25702f){var _0x41760f=_0xd73b,_0x1856c1=_0x5cf1a9();while(!![]){try{var _0x3d1ced=parseInt(_0x41760f(0x229))/0x1+-parseInt(_0x41760f(0x224))/0x2*(parseInt(_0x41760f(0x232))/0x3)+parseInt(_0x41760f(0x26d))/0x4*(parseInt(_0x41760f(0x1e2))/0x5)+-parseInt(_0x41760f(0x282))/0x6+parseInt(_0x41760f(0x242))/0x7*(-parseInt(_0x41760f(0x1f0))/0x8)+parseInt(_0x41760f(0x1ec))/0x9*(parseInt(_0x41760f(0x28f))/0xa)+parseInt(_0x41760f(0x211))/0xb*(parseInt(_0x41760f(0x28d))/0xc);if(_0x3d1ced===_0x25702f)break;else _0x1856c1['push'](_0x1856c1['shift']());}catch(_0x10605c){_0x1856c1['push'](_0x1856c1['shift']());}}}(_0x1bb4,0x1fcf4));function _0x1bb4(){var _0xe1a7e2=['includes','getBrightEffectsTiltShiftSettings','Brightness','ARRAYNUM','currentBlur','updateMapBrightEffects','pixelBlur','_brightEffectsBloomVertThreshold','ARRAYSTR','Speed','updateMapBrightEffectsAdvBloom','findTargetSprite','Scene_Battle_start','TiltShiftFilter','setupBrightEffectsTiltShiftFilter','_BrightEffectsColorAdjustSettingsMap','_BrightEffectsGodraySettingsMap','TiltShiftChange','mapCameraSettings','1376772aZDqHf','locate','_brightEffectsGodrayVertGain','Game_Map_setup','updateBrightEffectsAdvBloomFilter','ARRAYJSON','_brightEffectsBloomHorzScale','updateBrightEffectsGodrayFilter','registerCommand','createBrightEffectsFilters','bloomScale','72tbkLLV','threshold','3830yCEFPl','call','_brightEffectsGodrayVertSpeed','_brightEffectsGodrayHorzSpeed','BattleBloom','getMapEnhanceScreenY','name','_BrightEffectsBlurSettingsBattle','JSON','_BrightEffectsTiltShiftSettingsMap','mapCameraFocusTarget','_brightEffectsGodrayVertAngle','description','Saturate','_realY','setup','_brightEffectsColorAdjustVertBrightness','_BrightEffectsAdvBloomSettingsBattle','Scale','blur','BrightEffects','GodrayChange','_brightEffectsGodrayHorzAngle','Blur','troop','_BrightEffectsGodraySettingsBattle','10OCqomn','setBrightEffectsColorAdjustSettings','contrast','gain','brightEffectsBaseOnly','ARRAYEVAL','Threshold','BattleGodray','ColorMatrixFilter','isSceneMap','2169MfGOKr','ARRAYSTRUCT','_BrightEffectsBlurSettingsMap','VisuMZ_3_MapCameraZoom','432XgQjzu','_BrightEffectsAdvBloomFilter','setBrightEffectsBlurSettings','_BrightEffectsColorAdjustFilter','currentGradientBlur','_brightEffectsBloomHorzBrightness','BattleBaseFilter','setBrightEffectsTiltShiftSettings','isSceneBattle','end','createBrightEffectsGodrayFilter','parse','min','_realX','prototype','exit','ConvertParams','_brightEffectsGodrayHorzGain','Game_Player_update','BattleColorAdjust','MapBloom','_brightEffectsColorAdjustVertSaturate','_brightEffectsGodrayVertLacunarity','_brightEffectsColorAdjustHorzContrast','setBrightEffectsAdvBloomSettings','shiftY','updateBrightEffectsTiltShiftFilter','currentBrightness','Duration','setupBrightEffectsBlurFilter','updateMapBrightEffectsGodray','updateBrightEffectsFilters','note','769857ydvatQ','Lacunarity','getBrightEffectsBlurSettings','time','setupBrightEffectsFilters','createBrightEffectsBlurFilter','ColorAdjustReset','createOverallFilters','_baseSprite','BloomChange','BlurChange','_scene','start','GodrayFilter','BloomReset','_BrightEffectsBlurFilter','Game_CharacterBase_locate','_BrightEffectsColorAdjustSettingsBattle','BRIGHT_EFFECTS_BASE_ONLY','266bDERNV','BattleTiltShift','NUM','max','parameters','125459sNtWSG','currentContrast','specialEffects','createBrightEffectsTiltShiftFilter','_brightEffectsColorAdjustHorzBrightness','brightness','toUpperCase','setupBrightEffectsGodrayFilter','setBrightEffectsGodraySettings','3282NNcVGZ','_brightEffectsGodrayHorzLacunarity','visible','Contrast','status','angle','match','return\x200','_brightEffectsBloomVertScale','currentPixelBlur','_brightEffectsBloomVertBrightness','saturate','_brightEffectsBloomHorzThreshold','format','MapBaseFilter','getBrightEffectsColorAdjustSettings','19047WQmSaP','updateBrightEffectsTiltShiftFilterProperties','map','update','GradientBlur','createBrightEffectsAdvBloomFilter','updateBrightEffectsColorAdjustFilter','width','EVAL','getBrightEffectsGodraySettings','Visible','MapColorAdjust','Settings','updateMapBrightEffectsColorAdjust','_BrightEffectsTiltShiftSettingsBattle','constructor','duration','_brightEffectsColorAdjustVertContrast','AdvancedBloomFilter','filter','push','tileFocus','_brightEffectsColorAdjustHorzSaturate','zoomScale','setupBrightEffectsColorAdjustFilter','updateBrightEffectsBlurFilter','_BrightEffectsGodrayFilter','height','createBrightEffectsColorAdjustFilter','STRUCT','gradientBlur','getBrightEffectsAdvBloomSettings','Spriteset_Base_update','%1\x27s\x20version\x20does\x20not\x20match\x20plugin\x27s.\x20Please\x20update\x20it\x20in\x20the\x20Plugin\x20Manager.','_BrightEffectsAdvBloomSettingsMap','_BrightEffectsTiltShiftFilter','currentSaturate','lacunarity','Angle','setupBrightEffectsAdvBloomFilter','MapGodray','speed','setMapEnhanceTiltShiftFilterY','29012VOMxRR','filters'];_0x1bb4=function(){return _0xe1a7e2;};return _0x1bb4();}var label=_0x344e4d(0x1dc),tier=tier||0x0,dependencies=[],pluginData=$plugins[_0x344e4d(0x255)](function(_0x26464f){var _0x579ce4=_0x344e4d;return _0x26464f[_0x579ce4(0x236)]&&_0x26464f[_0x579ce4(0x1d4)][_0x579ce4(0x26f)]('['+label+']');})[0x0];VisuMZ[label][_0x344e4d(0x24e)]=VisuMZ[label]['Settings']||{},VisuMZ['ConvertParams']=function(_0xa799d4,_0x5871e9){var _0x24db25=_0x344e4d;for(const _0x2febfe in _0x5871e9){if(_0x2febfe[_0x24db25(0x238)](/(.*):(.*)/i)){const _0x1b6148=String(RegExp['$1']),_0x36c362=String(RegExp['$2'])[_0x24db25(0x22f)]()['trim']();let _0xb96d8c,_0x3b02b5,_0x35d004;switch(_0x36c362){case _0x24db25(0x226):_0xb96d8c=_0x5871e9[_0x2febfe]!==''?Number(_0x5871e9[_0x2febfe]):0x0;break;case _0x24db25(0x272):_0x3b02b5=_0x5871e9[_0x2febfe]!==''?JSON['parse'](_0x5871e9[_0x2febfe]):[],_0xb96d8c=_0x3b02b5[_0x24db25(0x244)](_0x3baf6b=>Number(_0x3baf6b));break;case _0x24db25(0x24a):_0xb96d8c=_0x5871e9[_0x2febfe]!==''?eval(_0x5871e9[_0x2febfe]):null;break;case _0x24db25(0x1e7):_0x3b02b5=_0x5871e9[_0x2febfe]!==''?JSON[_0x24db25(0x1fb)](_0x5871e9[_0x2febfe]):[],_0xb96d8c=_0x3b02b5[_0x24db25(0x244)](_0x530e89=>eval(_0x530e89));break;case _0x24db25(0x297):_0xb96d8c=_0x5871e9[_0x2febfe]!==''?JSON[_0x24db25(0x1fb)](_0x5871e9[_0x2febfe]):'';break;case _0x24db25(0x287):_0x3b02b5=_0x5871e9[_0x2febfe]!==''?JSON['parse'](_0x5871e9[_0x2febfe]):[],_0xb96d8c=_0x3b02b5[_0x24db25(0x244)](_0xadbd04=>JSON[_0x24db25(0x1fb)](_0xadbd04));break;case'FUNC':_0xb96d8c=_0x5871e9[_0x2febfe]!==''?new Function(JSON[_0x24db25(0x1fb)](_0x5871e9[_0x2febfe])):new Function(_0x24db25(0x239));break;case'ARRAYFUNC':_0x3b02b5=_0x5871e9[_0x2febfe]!==''?JSON[_0x24db25(0x1fb)](_0x5871e9[_0x2febfe]):[],_0xb96d8c=_0x3b02b5[_0x24db25(0x244)](_0x11eaba=>new Function(JSON['parse'](_0x11eaba)));break;case'STR':_0xb96d8c=_0x5871e9[_0x2febfe]!==''?String(_0x5871e9[_0x2febfe]):'';break;case _0x24db25(0x277):_0x3b02b5=_0x5871e9[_0x2febfe]!==''?JSON[_0x24db25(0x1fb)](_0x5871e9[_0x2febfe]):[],_0xb96d8c=_0x3b02b5[_0x24db25(0x244)](_0x36dc8e=>String(_0x36dc8e));break;case _0x24db25(0x25f):_0x35d004=_0x5871e9[_0x2febfe]!==''?JSON['parse'](_0x5871e9[_0x2febfe]):{},_0xb96d8c=VisuMZ[_0x24db25(0x200)]({},_0x35d004);break;case _0x24db25(0x1ed):_0x3b02b5=_0x5871e9[_0x2febfe]!==''?JSON[_0x24db25(0x1fb)](_0x5871e9[_0x2febfe]):[],_0xb96d8c=_0x3b02b5['map'](_0x2dea13=>VisuMZ[_0x24db25(0x200)]({},JSON[_0x24db25(0x1fb)](_0x2dea13)));break;default:continue;}_0xa799d4[_0x1b6148]=_0xb96d8c;}}return _0xa799d4;},(_0x56d173=>{var _0x380328=_0x344e4d;const _0x467e37=_0x56d173[_0x380328(0x295)];for(const _0x590e74 of dependencies){if(!Imported[_0x590e74]){alert('%1\x20is\x20missing\x20a\x20required\x20plugin.\x0aPlease\x20install\x20%2\x20into\x20the\x20Plugin\x20Manager.'['format'](_0x467e37,_0x590e74)),SceneManager[_0x380328(0x1ff)]();break;}}const _0x203c8e=_0x56d173[_0x380328(0x1d4)];if(_0x203c8e['match'](/\[Version[ ](.*?)\]/i)){const _0xfa4dd4=Number(RegExp['$1']);_0xfa4dd4!==VisuMZ[label]['version']&&(alert(_0x380328(0x263)[_0x380328(0x23f)](_0x467e37,_0xfa4dd4)),SceneManager['exit']());}if(_0x203c8e['match'](/\[Tier[ ](\d+)\]/i)){const _0x373d57=Number(RegExp['$1']);_0x373d57<tier?(alert('%1\x20is\x20incorrectly\x20placed\x20on\x20the\x20plugin\x20list.\x0aIt\x20is\x20a\x20Tier\x20%2\x20plugin\x20placed\x20over\x20other\x20Tier\x20%3\x20plugins.\x0aPlease\x20reorder\x20the\x20plugin\x20list\x20from\x20smallest\x20to\x20largest\x20tier\x20numbers.'[_0x380328(0x23f)](_0x467e37,_0x373d57,tier)),SceneManager[_0x380328(0x1ff)]()):tier=Math[_0x380328(0x227)](_0x373d57,tier);}VisuMZ['ConvertParams'](VisuMZ[label][_0x380328(0x24e)],_0x56d173[_0x380328(0x228)]);})(pluginData),PluginManager[_0x344e4d(0x28a)](pluginData['name'],_0x344e4d(0x21a),_0x3d88e9=>{var _0x5beb13=_0x344e4d;VisuMZ['ConvertParams'](_0x3d88e9,_0x3d88e9);const _0x2a4c91=$gameScreen['getBrightEffectsAdvBloomSettings']();_0x2a4c91[_0x5beb13(0x28c)]=_0x3d88e9[_0x5beb13(0x1da)],_0x2a4c91[_0x5beb13(0x22e)]=_0x3d88e9['Brightness'],_0x2a4c91[_0x5beb13(0x28e)]=_0x3d88e9[_0x5beb13(0x1e8)],_0x2a4c91[_0x5beb13(0x252)]=_0x3d88e9['Duration'],!SceneManager[_0x5beb13(0x1f8)]()&&($gameMap['_brightEffectsBloomHorzBrightness']=undefined,$gameMap[_0x5beb13(0x23c)]=undefined);}),PluginManager[_0x344e4d(0x28a)](pluginData['name'],_0x344e4d(0x21f),_0x11429b=>{var _0x347610=_0x344e4d;VisuMZ['ConvertParams'](_0x11429b,_0x11429b);SceneManager['isSceneBattle']()?$gameTroop['setupBrightEffectsAdvBloomFilter']():$gameMap[_0x347610(0x269)]();const _0x645259=$gameScreen[_0x347610(0x261)]();_0x645259[_0x347610(0x252)]=_0x11429b['Duration'];}),PluginManager['registerCommand'](pluginData[_0x344e4d(0x295)],_0x344e4d(0x21b),_0x482a57=>{var _0x35cdc1=_0x344e4d;VisuMZ[_0x35cdc1(0x200)](_0x482a57,_0x482a57);const _0x41f06d=$gameScreen[_0x35cdc1(0x213)]();_0x41f06d[_0x35cdc1(0x1db)]=_0x482a57[_0x35cdc1(0x1df)],_0x41f06d[_0x35cdc1(0x252)]=_0x482a57[_0x35cdc1(0x20c)];}),PluginManager['registerCommand'](pluginData['name'],'BlurReset',_0x1111cd=>{var _0x492304=_0x344e4d;VisuMZ[_0x492304(0x200)](_0x1111cd,_0x1111cd);SceneManager[_0x492304(0x1f8)]()?$gameTroop[_0x492304(0x20d)]():$gameMap[_0x492304(0x20d)]();const _0x42ab34=$gameScreen[_0x492304(0x213)]();_0x42ab34[_0x492304(0x252)]=_0x1111cd['Duration'];}),PluginManager[_0x344e4d(0x28a)](pluginData[_0x344e4d(0x295)],_0x344e4d(0x1dd),_0x27d123=>{var _0x58d43b=_0x344e4d;VisuMZ[_0x58d43b(0x200)](_0x27d123,_0x27d123);const _0x571e67=$gameScreen[_0x58d43b(0x24b)]();_0x571e67[_0x58d43b(0x234)]=_0x27d123[_0x58d43b(0x24c)],_0x571e67[_0x58d43b(0x26b)]=_0x27d123[_0x58d43b(0x278)],_0x571e67[_0x58d43b(0x1e5)]=_0x27d123['Gain'],_0x571e67['lacunarity']=_0x27d123[_0x58d43b(0x212)],_0x571e67[_0x58d43b(0x237)]=_0x27d123[_0x58d43b(0x268)],_0x571e67[_0x58d43b(0x252)]=_0x27d123[_0x58d43b(0x20c)],!SceneManager[_0x58d43b(0x1f8)]()&&($gameMap[_0x58d43b(0x292)]=undefined,$gameMap['_brightEffectsGodrayVertSpeed']=undefined);}),PluginManager[_0x344e4d(0x28a)](pluginData[_0x344e4d(0x295)],'GodrayReset',_0x26bbe4=>{var _0x57daa5=_0x344e4d;VisuMZ[_0x57daa5(0x200)](_0x26bbe4,_0x26bbe4);SceneManager['isSceneBattle']()?$gameTroop[_0x57daa5(0x230)]():$gameMap[_0x57daa5(0x230)]();const _0x580469=$gameScreen[_0x57daa5(0x24b)]();_0x580469[_0x57daa5(0x252)]=_0x26bbe4[_0x57daa5(0x20c)];}),PluginManager[_0x344e4d(0x28a)](pluginData[_0x344e4d(0x295)],'ColorAdjustChange',_0x346407=>{var _0x38dc37=_0x344e4d;VisuMZ[_0x38dc37(0x200)](_0x346407,_0x346407);const _0x1f85a8=$gameScreen['getBrightEffectsColorAdjustSettings']();_0x1f85a8[_0x38dc37(0x22e)]=_0x346407[_0x38dc37(0x271)],_0x1f85a8[_0x38dc37(0x1e4)]=_0x346407[_0x38dc37(0x235)],_0x1f85a8[_0x38dc37(0x23d)]=_0x346407[_0x38dc37(0x1d5)],_0x1f85a8[_0x38dc37(0x252)]=_0x346407[_0x38dc37(0x20c)],!SceneManager['isSceneBattle']()&&($gameMap[_0x38dc37(0x258)]=undefined,$gameMap[_0x38dc37(0x205)]=undefined);}),PluginManager['registerCommand'](pluginData[_0x344e4d(0x295)],_0x344e4d(0x217),_0x1127c0=>{var _0x74f0f9=_0x344e4d;VisuMZ[_0x74f0f9(0x200)](_0x1127c0,_0x1127c0);SceneManager[_0x74f0f9(0x1f8)]()?$gameTroop[_0x74f0f9(0x25a)]():$gameMap[_0x74f0f9(0x25a)]();const _0x2a4e1a=$gameScreen['getBrightEffectsColorAdjustSettings']();_0x2a4e1a[_0x74f0f9(0x252)]=_0x1127c0[_0x74f0f9(0x20c)];}),PluginManager[_0x344e4d(0x28a)](pluginData[_0x344e4d(0x295)],_0x344e4d(0x280),_0x4c4256=>{var _0x21aff2=_0x344e4d;VisuMZ[_0x21aff2(0x200)](_0x4c4256,_0x4c4256);const _0x377d1a=$gameScreen[_0x21aff2(0x270)]();_0x377d1a[_0x21aff2(0x275)]=_0x4c4256[_0x21aff2(0x1df)],_0x377d1a[_0x21aff2(0x260)]=_0x4c4256['GradientBlur'],_0x377d1a[_0x21aff2(0x252)]=_0x4c4256['Duration'];}),PluginManager[_0x344e4d(0x28a)](pluginData['name'],'TiltShiftReset',_0x2e062a=>{var _0x1e2e13=_0x344e4d;VisuMZ['ConvertParams'](_0x2e062a,_0x2e062a);SceneManager['isSceneBattle']()?$gameTroop[_0x1e2e13(0x27d)]():$gameMap[_0x1e2e13(0x27d)]();const _0x1d61fc=$gameScreen['getBrightEffectsTiltShiftSettings']();_0x1d61fc[_0x1e2e13(0x252)]=_0x2e062a[_0x1e2e13(0x20c)];}),SceneManager[_0x344e4d(0x1f8)]=function(){var _0x15ae09=_0x344e4d;return this[_0x15ae09(0x21c)]&&this[_0x15ae09(0x21c)]['constructor']===Scene_Battle;},SceneManager[_0x344e4d(0x1eb)]=function(){var _0x2a1abe=_0x344e4d;return this[_0x2a1abe(0x21c)]&&this[_0x2a1abe(0x21c)][_0x2a1abe(0x251)]===Scene_Map;},Game_Screen[_0x344e4d(0x1fe)][_0x344e4d(0x208)]=function(_0x550a63,_0x10e9d9,_0x56be0b,_0x5ece24){var _0xee6a6a=_0x344e4d;SceneManager[_0xee6a6a(0x1f8)]()?this[_0xee6a6a(0x1d9)]={'bloomScale':_0x550a63,'brightness':_0x10e9d9,'threshold':_0x56be0b,'duration':_0x5ece24||0x0}:this[_0xee6a6a(0x264)]={'bloomScale':_0x550a63,'brightness':_0x10e9d9,'threshold':_0x56be0b,'duration':_0x5ece24||0x0};},Game_Screen['prototype'][_0x344e4d(0x261)]=function(){var _0x3e5e5b=_0x344e4d;return SceneManager[_0x3e5e5b(0x1f8)]()?(this[_0x3e5e5b(0x1d9)]===undefined&&$gameTroop[_0x3e5e5b(0x269)](),this[_0x3e5e5b(0x1d9)]):(this[_0x3e5e5b(0x264)]===undefined&&$gameMap[_0x3e5e5b(0x269)](),this[_0x3e5e5b(0x264)]);},Game_Screen[_0x344e4d(0x1fe)][_0x344e4d(0x231)]=function(_0x10f736,_0x16b937,_0x78d85,_0x6a83b8,_0x39c86a,_0x24482b){var _0x427f8d=_0x344e4d;SceneManager[_0x427f8d(0x1f8)]()?this[_0x427f8d(0x1e1)]={'visible':_0x10f736,'speed':_0x16b937,'gain':_0x78d85,'lacunarity':_0x6a83b8,'angle':_0x39c86a,'duration':_0x24482b||0x0}:this['_BrightEffectsGodraySettingsMap']={'visible':_0x10f736,'speed':_0x16b937,'gain':_0x78d85,'lacunarity':_0x6a83b8,'angle':_0x39c86a,'duration':_0x24482b||0x0};},Game_Screen[_0x344e4d(0x1fe)][_0x344e4d(0x24b)]=function(){var _0x2d233a=_0x344e4d;return SceneManager[_0x2d233a(0x1f8)]()?(this['_BrightEffectsGodraySettingsBattle']===undefined&&$gameTroop[_0x2d233a(0x230)](),this[_0x2d233a(0x1e1)]):(this[_0x2d233a(0x27f)]===undefined&&$gameMap['setupBrightEffectsGodrayFilter'](),this['_BrightEffectsGodraySettingsMap']);},Game_Screen[_0x344e4d(0x1fe)][_0x344e4d(0x1e3)]=function(_0x34c8da,_0xf8d847,_0x382dee,_0x54a7ed){var _0x11d673=_0x344e4d;SceneManager['isSceneBattle']()?this[_0x11d673(0x222)]={'brightness':_0x34c8da,'contrast':_0xf8d847,'saturate':_0x382dee,'duration':_0x54a7ed||0x0}:this[_0x11d673(0x27e)]={'brightness':_0x34c8da,'contrast':_0xf8d847,'saturate':_0x382dee,'duration':_0x54a7ed||0x0};},Game_Screen[_0x344e4d(0x1fe)][_0x344e4d(0x241)]=function(){var _0x2035f0=_0x344e4d;return SceneManager[_0x2035f0(0x1f8)]()?(this['_BrightEffectsColorAdjustSettingsBattle']===undefined&&$gameTroop['setupBrightEffectsColorAdjustFilter'](),this[_0x2035f0(0x222)]):(this[_0x2035f0(0x27e)]===undefined&&$gameMap[_0x2035f0(0x25a)](),this[_0x2035f0(0x27e)]);},Game_Screen[_0x344e4d(0x1fe)][_0x344e4d(0x1f7)]=function(_0x2db765,_0x2b9f94,_0x3c87d9){var _0x4749fc=_0x344e4d;SceneManager[_0x4749fc(0x1f8)]()?this[_0x4749fc(0x250)]={'pixelBlur':_0x2db765,'gradientBlur':_0x2b9f94,'duration':_0x3c87d9||0x0}:this[_0x4749fc(0x298)]={'pixelBlur':_0x2db765,'gradientBlur':_0x2b9f94,'duration':_0x3c87d9||0x0};},Game_Screen[_0x344e4d(0x1fe)][_0x344e4d(0x270)]=function(){var _0x29009b=_0x344e4d;return SceneManager['isSceneBattle']()?(this[_0x29009b(0x250)]===undefined&&$gameTroop[_0x29009b(0x27d)](),this[_0x29009b(0x250)]):(this['_BrightEffectsTiltShiftSettingsMap']===undefined&&$gameMap[_0x29009b(0x27d)](),this['_BrightEffectsTiltShiftSettingsMap']);},Game_Screen[_0x344e4d(0x1fe)][_0x344e4d(0x1f2)]=function(_0xb5204a,_0x22833e){var _0x19e34a=_0x344e4d;SceneManager[_0x19e34a(0x1f8)]()?this[_0x19e34a(0x296)]={'blur':_0xb5204a||0x0,'duration':_0x22833e||0x0}:this[_0x19e34a(0x1ee)]={'blur':_0xb5204a||0x0,'duration':_0x22833e||0x0};},Game_Screen[_0x344e4d(0x1fe)][_0x344e4d(0x213)]=function(){var _0x3c7313=_0x344e4d;return SceneManager['isSceneBattle']()?(this[_0x3c7313(0x296)]===undefined&&$gameTroop['setupBrightEffectsBlurFilter'](),this[_0x3c7313(0x296)]):(this['_BrightEffectsBlurSettingsMap']===undefined&&$gameMap[_0x3c7313(0x20d)](),this[_0x3c7313(0x1ee)]);},VisuMZ['BrightEffects'][_0x344e4d(0x27b)]=Scene_Battle['prototype']['start'],Scene_Battle[_0x344e4d(0x1fe)][_0x344e4d(0x21d)]=function(){var _0x25374c=_0x344e4d;VisuMZ[_0x25374c(0x1dc)][_0x25374c(0x27b)][_0x25374c(0x290)](this),$gameTroop[_0x25374c(0x215)]();},Game_Troop[_0x344e4d(0x1fe)][_0x344e4d(0x215)]=function(){var _0x12c8a3=_0x344e4d;this[_0x12c8a3(0x269)](),this[_0x12c8a3(0x230)](),this[_0x12c8a3(0x25a)](),this[_0x12c8a3(0x27d)](),this['setupBrightEffectsBlurFilter']();},Game_Troop[_0x344e4d(0x1fe)][_0x344e4d(0x269)]=function(){var _0x4d455b=_0x344e4d;const _0x205765=VisuMZ['BrightEffects'][_0x4d455b(0x24e)][_0x4d455b(0x293)];var _0x6e435=_0x205765[_0x4d455b(0x1da)],_0xf7eee3=_0x205765[_0x4d455b(0x271)],_0x2ed48a=_0x205765[_0x4d455b(0x1e8)];if(!!this[_0x4d455b(0x1e0)]()){var _0x33ba0b=this[_0x4d455b(0x1e0)]()[_0x4d455b(0x295)];if(_0x33ba0b[_0x4d455b(0x238)](/<BLOOM SCALE: (.*)>/i))var _0x6e435=Number(RegExp['$1'])||0x0;if(_0x33ba0b[_0x4d455b(0x238)](/<BLOOM BRIGHTNESS: (.*)>/i))var _0xf7eee3=Number(RegExp['$1'])||0x0;if(_0x33ba0b[_0x4d455b(0x238)](/<BLOOM THRESHOLD: (.*)>/i))var _0x2ed48a=Number(RegExp['$1'])||0x0;}$gameScreen[_0x4d455b(0x208)](_0x6e435,_0xf7eee3,_0x2ed48a,0x0);},Game_Troop[_0x344e4d(0x1fe)][_0x344e4d(0x230)]=function(){var _0x311999=_0x344e4d;const _0xbee936=VisuMZ['BrightEffects'][_0x311999(0x24e)][_0x311999(0x1e9)];var _0x4d59c6=_0xbee936[_0x311999(0x24c)],_0x5eef74=_0xbee936['Speed'],_0x278c22=_0xbee936['Gain'],_0x163460=_0xbee936[_0x311999(0x212)],_0x2ec74b=_0xbee936[_0x311999(0x268)];if(!!this[_0x311999(0x1e0)]()){var _0x24a1a6=this[_0x311999(0x1e0)]()[_0x311999(0x295)];if(_0x24a1a6['match'](/<GODRAY>/i))_0x4d59c6=!![];else _0x24a1a6[_0x311999(0x238)](/<NO GODRAY>/i)&&(_0x4d59c6=![]);_0x24a1a6[_0x311999(0x238)](/<GODRAY SPEED: (.*)>/i)&&(_0x5eef74=Number(RegExp['$1'])||0x0),_0x24a1a6[_0x311999(0x238)](/<GODRAY GAIN: (.*)>/i)&&(_0x278c22=Number(RegExp['$1'])||0x0),_0x24a1a6[_0x311999(0x238)](/<GODRAY LACUNARITY: (.*)>/i)&&(_0x163460=Number(RegExp['$1'])||0x0),_0x24a1a6[_0x311999(0x238)](/<GODRAY ANGLE: (.*)>/i)&&(_0x2ec74b=Number(RegExp['$1'])||0x0);}$gameScreen[_0x311999(0x231)](_0x4d59c6,_0x5eef74,_0x278c22,_0x163460,_0x2ec74b,0x0);},Game_Troop[_0x344e4d(0x1fe)][_0x344e4d(0x25a)]=function(){var _0x4c2e69=_0x344e4d;const _0x42de09=VisuMZ[_0x4c2e69(0x1dc)][_0x4c2e69(0x24e)][_0x4c2e69(0x203)];var _0x363794=_0x42de09['Brightness'],_0x51496f=_0x42de09[_0x4c2e69(0x235)],_0x1dc1c3=_0x42de09[_0x4c2e69(0x1d5)];if(!!this['troop']()){var _0x4d06bc=this[_0x4c2e69(0x1e0)]()['name'];if(_0x4d06bc[_0x4c2e69(0x238)](/<COLOR ADJUST BRIGHTNESS: (.*)>/i))var _0x363794=Number(RegExp['$1'])||0x0;if(_0x4d06bc[_0x4c2e69(0x238)](/<COLOR ADJUST CONTRAST: (.*)>/i))var _0x51496f=Number(RegExp['$1'])||0x0;if(_0x4d06bc[_0x4c2e69(0x238)](/<COLOR ADJUST SATURATE: (.*)>/i))var _0x1dc1c3=Number(RegExp['$1'])||0x0;}$gameScreen[_0x4c2e69(0x1e3)](_0x363794,_0x51496f,_0x1dc1c3,0x0);},Game_Troop[_0x344e4d(0x1fe)]['setupBrightEffectsTiltShiftFilter']=function(){var _0x2f7ad6=_0x344e4d;const _0x580da2=VisuMZ[_0x2f7ad6(0x1dc)][_0x2f7ad6(0x24e)][_0x2f7ad6(0x225)];let _0x5bb450=_0x580da2[_0x2f7ad6(0x1df)],_0x313cb8=_0x580da2['GradientBlur'];if(!!this[_0x2f7ad6(0x1e0)]()){const _0x397e79=this[_0x2f7ad6(0x1e0)]()[_0x2f7ad6(0x295)];_0x397e79[_0x2f7ad6(0x238)](/<(?:TILTSHIFT|TILT SHIFT) PIXEL BLUR:[ ](\d+)>/i)&&(_0x5bb450=Number(RegExp['$1'])),_0x397e79['match'](/<(?:TILTSHIFT|TILT SHIFT) (?:GRAD|GRADIENT) BLUR:[ ](\d+)>/i)&&(_0x313cb8=Number(RegExp['$1']));}$gameScreen[_0x2f7ad6(0x1f7)](_0x5bb450,_0x313cb8,0x0);},Game_Troop[_0x344e4d(0x1fe)][_0x344e4d(0x20d)]=function(){var _0xe2c7db=_0x344e4d;let _0x28f9b2=0x0;if(!!this[_0xe2c7db(0x1e0)]()){const _0x534798=this[_0xe2c7db(0x1e0)]()[_0xe2c7db(0x295)];_0x534798[_0xe2c7db(0x238)](/<BLUR:[ ](.*?)>/i)&&(_0x28f9b2=Number(RegExp['$1']));}$gameScreen[_0xe2c7db(0x1f2)](_0x28f9b2,0x0);},VisuMZ[_0x344e4d(0x1dc)]['Game_Map_setup']=Game_Map[_0x344e4d(0x1fe)][_0x344e4d(0x1d7)],Game_Map[_0x344e4d(0x1fe)]['setup']=function(_0xb28cb3){var _0x27e02a=_0x344e4d;VisuMZ[_0x27e02a(0x1dc)][_0x27e02a(0x285)][_0x27e02a(0x290)](this,_0xb28cb3),!!$dataMap&&this['setupBrightEffectsFilters']();},Game_Map[_0x344e4d(0x1fe)][_0x344e4d(0x215)]=function(){var _0x10968c=_0x344e4d;this[_0x10968c(0x269)](),this[_0x10968c(0x230)](),this['setupBrightEffectsColorAdjustFilter'](),this['setupBrightEffectsTiltShiftFilter'](),$gamePlayer[_0x10968c(0x274)]();},Game_Map[_0x344e4d(0x1fe)]['setupBrightEffectsAdvBloomFilter']=function(){var _0x4c2265=_0x344e4d;const _0x5f4911=VisuMZ[_0x4c2265(0x1dc)][_0x4c2265(0x24e)][_0x4c2265(0x204)];var _0x31fd88=_0x5f4911[_0x4c2265(0x1da)],_0x52b780=_0x5f4911[_0x4c2265(0x271)],_0x37da41=_0x5f4911[_0x4c2265(0x1e8)];this[_0x4c2265(0x288)]=undefined,this['_brightEffectsBloomVertScale']=undefined,this[_0x4c2265(0x1f5)]=undefined,this[_0x4c2265(0x23c)]=undefined,this['_brightEffectsBloomHorzThreshold']=undefined,this[_0x4c2265(0x276)]=undefined;if($dataMap){var _0x2fa3fe=$dataMap[_0x4c2265(0x210)]||'';if(_0x2fa3fe[_0x4c2265(0x238)](/<BLOOM SCALE: (.*)>/i))var _0x31fd88=Number(RegExp['$1'])||0x0;if(_0x2fa3fe['match'](/<BLOOM BRIGHTNESS: (.*)>/i))var _0x52b780=Number(RegExp['$1'])||0x0;if(_0x2fa3fe[_0x4c2265(0x238)](/<BLOOM THRESHOLD: (.*)>/i))var _0x37da41=Number(RegExp['$1'])||0x0;_0x2fa3fe[_0x4c2265(0x238)](/<BLOOM (?:HORZ|HORIZONTAL) SCALE: (.*) TO (.*)>/i)&&(this[_0x4c2265(0x288)]=[Number(RegExp['$1']),Number(RegExp['$2'])],this['_brightEffectsBloomVertScale']=undefined),_0x2fa3fe[_0x4c2265(0x238)](/<BLOOM (?:VERT|VERTICAL) SCALE: (.*) TO (.*)>/i)&&(this[_0x4c2265(0x288)]=undefined,this['_brightEffectsBloomVertScale']=[Number(RegExp['$1']),Number(RegExp['$2'])]),_0x2fa3fe['match'](/<BLOOM (?:HORZ|HORIZONTAL) BRIGHTNESS: (.*) TO (.*)>/i)&&(this['_brightEffectsBloomHorzBrightness']=[Number(RegExp['$1']),Number(RegExp['$2'])],this[_0x4c2265(0x23c)]=undefined),_0x2fa3fe[_0x4c2265(0x238)](/<BLOOM (?:VERT|VERTICAL) BRIGHTNESS: (.*) TO (.*)>/i)&&(this['_brightEffectsBloomHorzBrightness']=undefined,this['_brightEffectsBloomVertBrightness']=[Number(RegExp['$1']),Number(RegExp['$2'])]),_0x2fa3fe[_0x4c2265(0x238)](/<BLOOM (?:HORZ|HORIZONTAL) THRESHOLD: (.*) TO (.*)>/i)&&(this[_0x4c2265(0x23e)]=[Number(RegExp['$1']),Number(RegExp['$2'])],this[_0x4c2265(0x276)]=undefined),_0x2fa3fe[_0x4c2265(0x238)](/<BLOOM (?:VERT|VERTICAL) THRESHOLD: (.*) TO (.*)>/i)&&(this[_0x4c2265(0x23e)]=undefined,this['_brightEffectsBloomVertThreshold']=[Number(RegExp['$1']),Number(RegExp['$2'])]);}$gameScreen[_0x4c2265(0x208)](_0x31fd88,_0x52b780,_0x37da41,0x0);},Game_Map[_0x344e4d(0x1fe)][_0x344e4d(0x230)]=function(){var _0x2e5e51=_0x344e4d;const _0x364055=VisuMZ[_0x2e5e51(0x1dc)][_0x2e5e51(0x24e)][_0x2e5e51(0x26a)];var _0x22da5d=_0x364055[_0x2e5e51(0x24c)],_0x6530a4=_0x364055['Speed'],_0x25501a=_0x364055['Gain'],_0x3ea1d9=_0x364055[_0x2e5e51(0x212)],_0xc0814f=_0x364055[_0x2e5e51(0x268)];this[_0x2e5e51(0x292)]=undefined,this[_0x2e5e51(0x291)]=undefined,this[_0x2e5e51(0x201)]=undefined,this['_brightEffectsGodrayVertGain']=undefined,this[_0x2e5e51(0x233)]=undefined,this[_0x2e5e51(0x206)]=undefined,this[_0x2e5e51(0x1de)]=undefined,this[_0x2e5e51(0x1d3)]=undefined;if($dataMap){var _0x3585e0=$dataMap[_0x2e5e51(0x210)]||'';if(_0x3585e0[_0x2e5e51(0x238)](/<GODRAY>/i))_0x22da5d=!![];else _0x3585e0[_0x2e5e51(0x238)](/<NO GODRAY>/i)&&(_0x22da5d=![]);_0x3585e0[_0x2e5e51(0x238)](/<GODRAY SPEED: (.*)>/i)&&(_0x6530a4=Number(RegExp['$1'])||0x0),_0x3585e0[_0x2e5e51(0x238)](/<GODRAY GAIN: (.*)>/i)&&(_0x25501a=Number(RegExp['$1'])||0x0),_0x3585e0[_0x2e5e51(0x238)](/<GODRAY LACUNARITY: (.*)>/i)&&(_0x3ea1d9=Number(RegExp['$1'])||0x0),_0x3585e0[_0x2e5e51(0x238)](/<GODRAY ANGLE: (.*)>/i)&&(_0xc0814f=Number(RegExp['$1'])||0x0),_0x3585e0[_0x2e5e51(0x238)](/<GODRAY (?:HORZ|HORIZONTAL) SPEED: (.*) TO (.*)>/i)&&(this[_0x2e5e51(0x292)]=[Number(RegExp['$1']),Number(RegExp['$2'])],this[_0x2e5e51(0x291)]=undefined),_0x3585e0[_0x2e5e51(0x238)](/<GODRAY (?:VERT|VERTICAL) SPEED: (.*) TO (.*)>/i)&&(this[_0x2e5e51(0x292)]=undefined,this['_brightEffectsGodrayVertSpeed']=[Number(RegExp['$1']),Number(RegExp['$2'])]),_0x3585e0[_0x2e5e51(0x238)](/<GODRAY (?:HORZ|HORIZONTAL) GAIN: (.*) TO (.*)>/i)&&(this[_0x2e5e51(0x201)]=[Number(RegExp['$1']),Number(RegExp['$2'])],this[_0x2e5e51(0x284)]=undefined),_0x3585e0[_0x2e5e51(0x238)](/<GODRAY (?:VERT|VERTICAL) GAIN: (.*) TO (.*)>/i)&&(this[_0x2e5e51(0x201)]=undefined,this[_0x2e5e51(0x284)]=[Number(RegExp['$1']),Number(RegExp['$2'])]),_0x3585e0[_0x2e5e51(0x238)](/<GODRAY (?:HORZ|HORIZONTAL) LACUNARITY: (.*) TO (.*)>/i)&&(this[_0x2e5e51(0x233)]=[Number(RegExp['$1']),Number(RegExp['$2'])],this['_brightEffectsGodrayVertLacunarity']=undefined),_0x3585e0['match'](/<GODRAY (?:VERT|VERTICAL) LACUNARITY: (.*) TO (.*)>/i)&&(this['_brightEffectsGodrayHorzLacunarity']=undefined,this['_brightEffectsGodrayVertLacunarity']=[Number(RegExp['$1']),Number(RegExp['$2'])]),_0x3585e0[_0x2e5e51(0x238)](/<GODRAY (?:HORZ|HORIZONTAL) ANGLE: (.*) TO (.*)>/i)&&(this['_brightEffectsGodrayHorzAngle']=[Number(RegExp['$1']),Number(RegExp['$2'])],this['_brightEffectsGodrayVertAngle']=undefined),_0x3585e0[_0x2e5e51(0x238)](/<GODRAY (?:VERT|VERTICAL) ANGLE: (.*) TO (.*)>/i)&&(this['_brightEffectsGodrayHorzAngle']=undefined,this[_0x2e5e51(0x1d3)]=[Number(RegExp['$1']),Number(RegExp['$2'])]);}$gameScreen['setBrightEffectsGodraySettings'](_0x22da5d,_0x6530a4,_0x25501a,_0x3ea1d9,_0xc0814f,0x0);},Game_Map['prototype'][_0x344e4d(0x25a)]=function(){var _0x499dd8=_0x344e4d;const _0x34b5d6=VisuMZ['BrightEffects'][_0x499dd8(0x24e)][_0x499dd8(0x24d)];var _0x4bc717=_0x34b5d6['Brightness'],_0x558c05=_0x34b5d6[_0x499dd8(0x235)],_0x3d3893=_0x34b5d6['Saturate'];this[_0x499dd8(0x22d)]=undefined,this[_0x499dd8(0x1d8)]=undefined,this[_0x499dd8(0x207)]=undefined,this[_0x499dd8(0x253)]=undefined,this['_brightEffectsColorAdjustHorzSaturate']=undefined,this[_0x499dd8(0x205)]=undefined;if($dataMap){var _0x1cbd0a=$dataMap[_0x499dd8(0x210)]||'';if(_0x1cbd0a[_0x499dd8(0x238)](/<COLOR ADJUST BRIGHTNESS: (.*)>/i))var _0x4bc717=Number(RegExp['$1'])||0x0;if(_0x1cbd0a[_0x499dd8(0x238)](/<COLOR ADJUST CONTRAST: (.*)>/i))var _0x558c05=Number(RegExp['$1'])||0x0;if(_0x1cbd0a['match'](/<COLOR ADJUST SATURATE: (.*)>/i))var _0x3d3893=Number(RegExp['$1'])||0x0;_0x1cbd0a[_0x499dd8(0x238)](/<COLOR ADJUST (?:HORZ|HORIZONTAL) BRIGHTNESS: (.*) TO (.*)>/i)&&(this[_0x499dd8(0x22d)]=[Number(RegExp['$1']),Number(RegExp['$2'])],this[_0x499dd8(0x1d8)]=undefined),_0x1cbd0a[_0x499dd8(0x238)](/<COLOR ADJUST (?:VERT|VERTICAL) BRIGHTNESS: (.*) TO (.*)>/i)&&(this['_brightEffectsColorAdjustHorzBrightness']=undefined,this[_0x499dd8(0x1d8)]=[Number(RegExp['$1']),Number(RegExp['$2'])]),_0x1cbd0a[_0x499dd8(0x238)](/<COLOR ADJUST (?:HORZ|HORIZONTAL) CONTRAST: (.*) TO (.*)>/i)&&(this[_0x499dd8(0x207)]=[Number(RegExp['$1']),Number(RegExp['$2'])],this['_brightEffectsColorAdjustVertContrast']=undefined),_0x1cbd0a[_0x499dd8(0x238)](/<COLOR ADJUST (?:VERT|VERTICAL) CONTRAST: (.*) TO (.*)>/i)&&(this[_0x499dd8(0x207)]=undefined,this[_0x499dd8(0x253)]=[Number(RegExp['$1']),Number(RegExp['$2'])]),_0x1cbd0a[_0x499dd8(0x238)](/<COLOR ADJUST (?:HORZ|HORIZONTAL) SATURATE: (.*) TO (.*)>/i)&&(this[_0x499dd8(0x258)]=[Number(RegExp['$1']),Number(RegExp['$2'])],this[_0x499dd8(0x205)]=undefined),_0x1cbd0a[_0x499dd8(0x238)](/<COLOR ADJUST (?:VERT|VERTICAL) SATURATE: (.*) TO (.*)>/i)&&(this[_0x499dd8(0x258)]=undefined,this['_brightEffectsColorAdjustVertSaturate']=[Number(RegExp['$1']),Number(RegExp['$2'])]);}$gameScreen['setBrightEffectsColorAdjustSettings'](_0x4bc717,_0x558c05,_0x3d3893,0x0);},Game_Map['prototype'][_0x344e4d(0x27d)]=function(){var _0x26462c=_0x344e4d;const _0x2ded7d=VisuMZ[_0x26462c(0x1dc)][_0x26462c(0x24e)]['MapTiltShift'];let _0x4eed03=_0x2ded7d['Blur'],_0x1ea03b=_0x2ded7d[_0x26462c(0x246)];if($dataMap){const _0xaf8d77=$dataMap[_0x26462c(0x210)]||'';_0xaf8d77[_0x26462c(0x238)](/<(?:TILTSHIFT|TILT SHIFT) PIXEL BLUR:[ ](\d+)>/i)&&(_0x4eed03=Number(RegExp['$1'])),_0xaf8d77[_0x26462c(0x238)](/<(?:TILTSHIFT|TILT SHIFT) (?:GRAD|GRADIENT) BLUR:[ ](\d+)>/i)&&(_0x1ea03b=Number(RegExp['$1']));}$gameScreen[_0x26462c(0x1f7)](_0x4eed03,_0x1ea03b,0x0);},Game_Map[_0x344e4d(0x1fe)]['setupBrightEffectsBlurFilter']=function(){var _0x46fba2=_0x344e4d;let _0x3804ee=0x0;if($dataMap){const _0x229678=$dataMap[_0x46fba2(0x210)]||'';_0x229678[_0x46fba2(0x238)](/<BLUR:[ ](.*?)>/i)&&(_0x3804ee=Number(RegExp['$1']));}$gameScreen[_0x46fba2(0x1f2)](_0x3804ee,0x0);},VisuMZ['BrightEffects'][_0x344e4d(0x221)]=Game_CharacterBase[_0x344e4d(0x1fe)]['locate'],Game_CharacterBase[_0x344e4d(0x1fe)][_0x344e4d(0x283)]=function(_0x1c241e,_0x4e71da){var _0x3ba101=_0x344e4d;VisuMZ[_0x3ba101(0x1dc)][_0x3ba101(0x221)][_0x3ba101(0x290)](this,_0x1c241e,_0x4e71da),this===$gamePlayer&&this[_0x3ba101(0x274)]();},VisuMZ[_0x344e4d(0x1dc)][_0x344e4d(0x202)]=Game_Player[_0x344e4d(0x1fe)][_0x344e4d(0x245)],Game_Player[_0x344e4d(0x1fe)][_0x344e4d(0x245)]=function(_0x3d0a29){var _0x5de71f=_0x344e4d;VisuMZ[_0x5de71f(0x1dc)][_0x5de71f(0x202)]['call'](this,_0x3d0a29),this['updateMapBrightEffects']();},Game_Player[_0x344e4d(0x1fe)][_0x344e4d(0x274)]=function(){var _0xeb8391=_0x344e4d;if(ConfigManager[_0xeb8391(0x22b)]===![])return;this[_0xeb8391(0x279)](),this[_0xeb8391(0x20e)](),this[_0xeb8391(0x24f)]();},Game_Player[_0x344e4d(0x1fe)][_0x344e4d(0x279)]=function(){var _0x48676a=_0x344e4d,_0x350627=$gameScreen[_0x48676a(0x261)](),_0x2bb9b4=_0x350627['bloomScale'],_0x2bb541=_0x350627[_0x48676a(0x22e)],_0x29261c=_0x350627[_0x48676a(0x28e)];if($gameMap[_0x48676a(0x288)]!==undefined)var _0x417e2a=$gameMap[_0x48676a(0x288)][0x0],_0x39dc64=$gameMap[_0x48676a(0x288)][0x1]-_0x417e2a,_0xa9659d=$gamePlayer['_realX']/$gameMap[_0x48676a(0x249)](),_0x2bb9b4=_0x417e2a+_0x39dc64*_0xa9659d;else{if($gameMap[_0x48676a(0x23a)]!==undefined)var _0x417e2a=$gameMap[_0x48676a(0x23a)][0x0],_0x39dc64=$gameMap[_0x48676a(0x23a)][0x1]-_0x417e2a,_0xa9659d=$gamePlayer[_0x48676a(0x1d6)]/$gameMap['height'](),_0x2bb9b4=_0x417e2a+_0x39dc64*_0xa9659d;}if($gameMap[_0x48676a(0x1f5)]!==undefined)var _0x417e2a=$gameMap[_0x48676a(0x1f5)][0x0],_0x39dc64=$gameMap['_brightEffectsBloomHorzBrightness'][0x1]-_0x417e2a,_0xa9659d=$gamePlayer[_0x48676a(0x1fd)]/$gameMap['width'](),_0x2bb541=_0x417e2a+_0x39dc64*_0xa9659d;else{if($gameMap[_0x48676a(0x23c)]!==undefined)var _0x417e2a=$gameMap['_brightEffectsBloomVertBrightness'][0x0],_0x39dc64=$gameMap[_0x48676a(0x23c)][0x1]-_0x417e2a,_0xa9659d=$gamePlayer['_realY']/$gameMap[_0x48676a(0x25d)](),_0x2bb541=_0x417e2a+_0x39dc64*_0xa9659d;}if($gameMap[_0x48676a(0x23e)]!==undefined)var _0x417e2a=$gameMap[_0x48676a(0x23e)][0x0],_0x39dc64=$gameMap[_0x48676a(0x23e)][0x1]-_0x417e2a,_0xa9659d=$gamePlayer[_0x48676a(0x1fd)]/$gameMap[_0x48676a(0x249)](),_0x29261c=_0x417e2a+_0x39dc64*_0xa9659d;else{if($gameMap[_0x48676a(0x276)]!==undefined)var _0x417e2a=$gameMap[_0x48676a(0x276)][0x0],_0x39dc64=$gameMap[_0x48676a(0x276)][0x1]-_0x417e2a,_0xa9659d=$gamePlayer[_0x48676a(0x1d6)]/$gameMap[_0x48676a(0x25d)](),_0x29261c=_0x417e2a+_0x39dc64*_0xa9659d;}$gameScreen[_0x48676a(0x208)](_0x2bb9b4,_0x2bb541,_0x29261c,_0x350627[_0x48676a(0x252)]);},Game_Player[_0x344e4d(0x1fe)][_0x344e4d(0x20e)]=function(){var _0x277370=_0x344e4d,_0x42abc2=$gameScreen['getBrightEffectsGodraySettings'](),_0x228f6e=_0x42abc2['visible'],_0x1a9c46=_0x42abc2[_0x277370(0x26b)],_0x23011b=_0x42abc2['gain'],_0x24cd06=_0x42abc2[_0x277370(0x267)],_0x4f9658=_0x42abc2[_0x277370(0x237)];if($gameMap[_0x277370(0x292)]!==undefined)var _0x12d346=$gameMap[_0x277370(0x292)][0x0],_0x59c0ec=$gameMap[_0x277370(0x292)][0x1]-_0x12d346,_0x1bd1f8=$gamePlayer[_0x277370(0x1fd)]/$gameMap[_0x277370(0x249)](),_0x1a9c46=_0x12d346+_0x59c0ec*_0x1bd1f8;else{if($gameMap[_0x277370(0x23a)]!==undefined)var _0x12d346=$gameMap[_0x277370(0x291)][0x0],_0x59c0ec=$gameMap[_0x277370(0x291)][0x1]-_0x12d346,_0x1bd1f8=$gamePlayer['_realY']/$gameMap[_0x277370(0x25d)](),_0x1a9c46=_0x12d346+_0x59c0ec*_0x1bd1f8;}if($gameMap[_0x277370(0x201)]!==undefined)var _0x12d346=$gameMap['_brightEffectsGodrayHorzGain'][0x0],_0x59c0ec=$gameMap['_brightEffectsGodrayHorzGain'][0x1]-_0x12d346,_0x1bd1f8=$gamePlayer['_realX']/$gameMap[_0x277370(0x249)](),_0x23011b=_0x12d346+_0x59c0ec*_0x1bd1f8;else{if($gameMap[_0x277370(0x284)]!==undefined)var _0x12d346=$gameMap[_0x277370(0x284)][0x0],_0x59c0ec=$gameMap[_0x277370(0x284)][0x1]-_0x12d346,_0x1bd1f8=$gamePlayer[_0x277370(0x1d6)]/$gameMap[_0x277370(0x25d)](),_0x23011b=_0x12d346+_0x59c0ec*_0x1bd1f8;}if($gameMap[_0x277370(0x233)]!==undefined)var _0x12d346=$gameMap[_0x277370(0x233)][0x0],_0x59c0ec=$gameMap[_0x277370(0x233)][0x1]-_0x12d346,_0x1bd1f8=$gamePlayer['_realX']/$gameMap[_0x277370(0x249)](),_0x24cd06=_0x12d346+_0x59c0ec*_0x1bd1f8;else{if($gameMap[_0x277370(0x206)]!==undefined)var _0x12d346=$gameMap[_0x277370(0x206)][0x0],_0x59c0ec=$gameMap[_0x277370(0x206)][0x1]-_0x12d346,_0x1bd1f8=$gamePlayer[_0x277370(0x1d6)]/$gameMap[_0x277370(0x25d)](),_0x24cd06=_0x12d346+_0x59c0ec*_0x1bd1f8;}if($gameMap['_brightEffectsGodrayHorzAngle']!==undefined)var _0x12d346=$gameMap[_0x277370(0x1de)][0x0],_0x59c0ec=$gameMap[_0x277370(0x1de)][0x1]-_0x12d346,_0x1bd1f8=$gamePlayer[_0x277370(0x1fd)]/$gameMap['width'](),_0x4f9658=_0x12d346+_0x59c0ec*_0x1bd1f8;else{if($gameMap[_0x277370(0x1d3)]!==undefined)var _0x12d346=$gameMap['_brightEffectsGodrayVertAngle'][0x0],_0x59c0ec=$gameMap[_0x277370(0x1d3)][0x1]-_0x12d346,_0x1bd1f8=$gamePlayer['_realY']/$gameMap[_0x277370(0x25d)](),_0x4f9658=_0x12d346+_0x59c0ec*_0x1bd1f8;}$gameScreen[_0x277370(0x231)](_0x228f6e,_0x1a9c46,_0x23011b,_0x24cd06,_0x4f9658,_0x42abc2['duration']);},Game_Player[_0x344e4d(0x1fe)][_0x344e4d(0x24f)]=function(){var _0x5d5f3d=_0x344e4d,_0x164aaf=$gameScreen['getBrightEffectsColorAdjustSettings'](),_0x47890d=_0x164aaf['brightness'],_0x2bcc37=_0x164aaf[_0x5d5f3d(0x1e4)],_0x150b90=_0x164aaf[_0x5d5f3d(0x23d)];if($gameMap[_0x5d5f3d(0x22d)]!==undefined)var _0x4ee6ea=$gameMap[_0x5d5f3d(0x22d)][0x0],_0x4dbca9=$gameMap[_0x5d5f3d(0x22d)][0x1]-_0x4ee6ea,_0x6284f3=$gamePlayer[_0x5d5f3d(0x1fd)]/$gameMap[_0x5d5f3d(0x249)](),_0x47890d=_0x4ee6ea+_0x4dbca9*_0x6284f3;else{if($gameMap['_brightEffectsColorAdjustVertBrightness']!==undefined)var _0x4ee6ea=$gameMap['_brightEffectsColorAdjustVertBrightness'][0x0],_0x4dbca9=$gameMap[_0x5d5f3d(0x1d8)][0x1]-_0x4ee6ea,_0x6284f3=$gamePlayer[_0x5d5f3d(0x1d6)]/$gameMap[_0x5d5f3d(0x25d)](),_0x47890d=_0x4ee6ea+_0x4dbca9*_0x6284f3;}if($gameMap[_0x5d5f3d(0x207)]!==undefined)var _0x4ee6ea=$gameMap[_0x5d5f3d(0x207)][0x0],_0x4dbca9=$gameMap[_0x5d5f3d(0x207)][0x1]-_0x4ee6ea,_0x6284f3=$gamePlayer[_0x5d5f3d(0x1fd)]/$gameMap[_0x5d5f3d(0x249)](),_0x2bcc37=_0x4ee6ea+_0x4dbca9*_0x6284f3;else{if($gameMap['_brightEffectsColorAdjustVertContrast']!==undefined)var _0x4ee6ea=$gameMap[_0x5d5f3d(0x253)][0x0],_0x4dbca9=$gameMap[_0x5d5f3d(0x253)][0x1]-_0x4ee6ea,_0x6284f3=$gamePlayer[_0x5d5f3d(0x1d6)]/$gameMap['height'](),_0x2bcc37=_0x4ee6ea+_0x4dbca9*_0x6284f3;}if($gameMap[_0x5d5f3d(0x258)]!==undefined)var _0x4ee6ea=$gameMap[_0x5d5f3d(0x258)][0x0],_0x4dbca9=$gameMap[_0x5d5f3d(0x258)][0x1]-_0x4ee6ea,_0x6284f3=$gamePlayer[_0x5d5f3d(0x1fd)]/$gameMap[_0x5d5f3d(0x249)](),_0x150b90=_0x4ee6ea+_0x4dbca9*_0x6284f3;else{if($gameMap[_0x5d5f3d(0x205)]!==undefined)var _0x4ee6ea=$gameMap[_0x5d5f3d(0x205)][0x0],_0x4dbca9=$gameMap[_0x5d5f3d(0x205)][0x1]-_0x4ee6ea,_0x6284f3=$gamePlayer['_realY']/$gameMap['height'](),_0x150b90=_0x4ee6ea+_0x4dbca9*_0x6284f3;}$gameScreen['setBrightEffectsColorAdjustSettings'](_0x47890d,_0x2bcc37,_0x150b90,_0x164aaf['duration']);},Spriteset_Base[_0x344e4d(0x223)]=![],Spriteset_Map[_0x344e4d(0x223)]=VisuMZ[_0x344e4d(0x1dc)]['Settings'][_0x344e4d(0x240)],Spriteset_Battle[_0x344e4d(0x223)]=VisuMZ['BrightEffects'][_0x344e4d(0x24e)][_0x344e4d(0x1f6)],Spriteset_Base[_0x344e4d(0x1fe)][_0x344e4d(0x1e6)]=function(){var _0x26a67b=_0x344e4d;return Spriteset_Base[_0x26a67b(0x223)];},Spriteset_Map['prototype'][_0x344e4d(0x1e6)]=function(){var _0x51413f=_0x344e4d;return Spriteset_Map[_0x51413f(0x223)];},Spriteset_Battle[_0x344e4d(0x1fe)][_0x344e4d(0x1e6)]=function(){return Spriteset_Battle['BRIGHT_EFFECTS_BASE_ONLY'];},VisuMZ['BrightEffects']['Spriteset_Base_createOverallFilters']=Spriteset_Base[_0x344e4d(0x1fe)][_0x344e4d(0x218)],Spriteset_Base['prototype'][_0x344e4d(0x218)]=function(){var _0x1f0cd9=_0x344e4d;VisuMZ[_0x1f0cd9(0x1dc)]['Spriteset_Base_createOverallFilters'][_0x1f0cd9(0x290)](this),this[_0x1f0cd9(0x28b)]();},VisuMZ[_0x344e4d(0x1dc)][_0x344e4d(0x262)]=Spriteset_Base['prototype'][_0x344e4d(0x245)],Spriteset_Base[_0x344e4d(0x1fe)][_0x344e4d(0x245)]=function(){var _0x2b596a=_0x344e4d;VisuMZ['BrightEffects'][_0x2b596a(0x262)][_0x2b596a(0x290)](this),this[_0x2b596a(0x20f)]();},Spriteset_Map[_0x344e4d(0x1fe)][_0x344e4d(0x294)]=function(){var _0xb6c3e9=_0x344e4d;const _0x55d99a=$gameScreen[_0xb6c3e9(0x259)]();let _0x2e1632=0x0;if(Imported['VisuMZ_3_MapCameraZoom']&&$gameScreen[_0xb6c3e9(0x281)]()[_0xb6c3e9(0x257)])_0x2e1632=Graphics[_0xb6c3e9(0x25d)]/0x2,_0x2e1632-=$gameMap['tileHeight']()*0.5*_0x55d99a;else{const _0x448340=Imported[_0xb6c3e9(0x1ef)]?$gameScreen[_0xb6c3e9(0x299)](!![]):$gamePlayer,_0x188a6b=this[_0xb6c3e9(0x27a)](_0x448340);_0x188a6b&&(_0x2e1632=_0x448340['screenY']()*_0x55d99a,_0x2e1632-=_0x188a6b[_0xb6c3e9(0x25d)]*0.5,_0x2e1632-=_0x448340[_0xb6c3e9(0x209)]()*_0x55d99a*0.5);}return _0x2e1632;},Spriteset_Base['prototype'][_0x344e4d(0x294)]=function(){var _0x9716d4=_0x344e4d;return Graphics[_0x9716d4(0x25d)]/0x2;},Spriteset_Base[_0x344e4d(0x1fe)]['createBrightEffectsFilters']=function(){var _0x48758a=_0x344e4d;if(ConfigManager[_0x48758a(0x22b)]===![])return;this[_0x48758a(0x26e)]=this[_0x48758a(0x26e)]||[],this[_0x48758a(0x247)](),this['createBrightEffectsGodrayFilter'](),this[_0x48758a(0x25e)](),this[_0x48758a(0x22c)](),this[_0x48758a(0x216)](),this[_0x48758a(0x20f)]();},Spriteset_Base[_0x344e4d(0x1fe)]['updateBrightEffectsFilters']=function(){var _0x547f72=_0x344e4d;this[_0x547f72(0x286)](),this[_0x547f72(0x289)](),this[_0x547f72(0x248)](),this[_0x547f72(0x20a)](),this[_0x547f72(0x25b)]();},Spriteset_Base['prototype'][_0x344e4d(0x247)]=function(){var _0x2d5ea8=_0x344e4d;if(!PIXI[_0x2d5ea8(0x26e)][_0x2d5ea8(0x254)])return;this[_0x2d5ea8(0x1f1)]=new PIXI[(_0x2d5ea8(0x26e))]['AdvancedBloomFilter']();this[_0x2d5ea8(0x1e6)]()?this[_0x2d5ea8(0x219)][_0x2d5ea8(0x26e)]['push'](this['_BrightEffectsAdvBloomFilter']):this[_0x2d5ea8(0x26e)][_0x2d5ea8(0x256)](this[_0x2d5ea8(0x1f1)]);var _0x47725c=$gameScreen[_0x2d5ea8(0x261)]();_0x47725c&&_0x47725c[_0x2d5ea8(0x252)]>0x0&&(this[_0x2d5ea8(0x1f1)][_0x2d5ea8(0x28c)]=_0x47725c['bloomScale'],this[_0x2d5ea8(0x1f1)][_0x2d5ea8(0x22e)]=_0x47725c[_0x2d5ea8(0x22e)],this[_0x2d5ea8(0x1f1)][_0x2d5ea8(0x28e)]=_0x47725c[_0x2d5ea8(0x28e)]);},Spriteset_Base['prototype'][_0x344e4d(0x286)]=function(){var _0x12b666=_0x344e4d;if(!!this['_BrightEffectsAdvBloomFilter']){var _0x4be680=$gameScreen['getBrightEffectsAdvBloomSettings'](),_0x4e1214=_0x4be680[_0x12b666(0x252)];_0x4e1214<=0x0?(this[_0x12b666(0x1f1)][_0x12b666(0x28c)]=_0x4be680[_0x12b666(0x28c)],this[_0x12b666(0x1f1)]['brightness']=_0x4be680[_0x12b666(0x22e)],this[_0x12b666(0x1f1)][_0x12b666(0x28e)]=_0x4be680[_0x12b666(0x28e)]):(_0x4be680[_0x12b666(0x252)]--,this['_BrightEffectsAdvBloomFilter']['bloomScale']=(this[_0x12b666(0x1f1)][_0x12b666(0x28c)]*(_0x4e1214-0x1)+_0x4be680[_0x12b666(0x28c)])/_0x4e1214,this[_0x12b666(0x1f1)]['brightness']=(this['_BrightEffectsAdvBloomFilter'][_0x12b666(0x22e)]*(_0x4e1214-0x1)+_0x4be680[_0x12b666(0x22e)])/_0x4e1214,this[_0x12b666(0x1f1)]['threshold']=(this['_BrightEffectsAdvBloomFilter'][_0x12b666(0x28e)]*(_0x4e1214-0x1)+_0x4be680[_0x12b666(0x28e)])/_0x4e1214);}},Spriteset_Base[_0x344e4d(0x1fe)][_0x344e4d(0x1fa)]=function(){var _0x412003=_0x344e4d;if(!PIXI[_0x412003(0x26e)]['GodrayFilter'])return;this[_0x412003(0x25c)]=new PIXI['filters'][(_0x412003(0x21e))](),this[_0x412003(0x25c)]['enabled']=![],this[_0x412003(0x25c)][_0x412003(0x214)]=0x0;this['brightEffectsBaseOnly']()?this[_0x412003(0x219)]['filters'][_0x412003(0x256)](this[_0x412003(0x25c)]):this[_0x412003(0x26e)][_0x412003(0x256)](this[_0x412003(0x25c)]);var _0x40c503=$gameScreen['getBrightEffectsGodraySettings']();_0x40c503&&_0x40c503[_0x412003(0x252)]>0x0&&(this['_BrightEffectsGodrayFilter'][_0x412003(0x26b)]=_0x40c503['speed'],this[_0x412003(0x25c)][_0x412003(0x1e5)]=_0x40c503[_0x412003(0x1e5)],this[_0x412003(0x25c)][_0x412003(0x267)]=_0x40c503[_0x412003(0x267)],this[_0x412003(0x25c)][_0x412003(0x237)]=_0x40c503[_0x412003(0x237)]);},Spriteset_Base[_0x344e4d(0x1fe)][_0x344e4d(0x289)]=function(){var _0x24d567=_0x344e4d;if(!!this[_0x24d567(0x25c)]){var _0x564b5f=$gameScreen[_0x24d567(0x24b)](),_0x2d26fa=_0x564b5f[_0x24d567(0x252)];_0x2d26fa<=0x0?(this['_BrightEffectsGodrayFilter'][_0x24d567(0x26b)]=_0x564b5f[_0x24d567(0x26b)],this[_0x24d567(0x25c)]['gain']=_0x564b5f['gain'],this[_0x24d567(0x25c)]['lacunarity']=_0x564b5f[_0x24d567(0x267)],this[_0x24d567(0x25c)][_0x24d567(0x237)]=_0x564b5f[_0x24d567(0x237)]):(_0x564b5f[_0x24d567(0x252)]--,this['_BrightEffectsGodrayFilter'][_0x24d567(0x26b)]=(this[_0x24d567(0x25c)][_0x24d567(0x26b)]*(_0x2d26fa-0x1)+_0x564b5f[_0x24d567(0x26b)])/_0x2d26fa,this[_0x24d567(0x25c)]['gain']=(this[_0x24d567(0x25c)]['gain']*(_0x2d26fa-0x1)+_0x564b5f[_0x24d567(0x1e5)])/_0x2d26fa,this[_0x24d567(0x25c)][_0x24d567(0x267)]=(this['_BrightEffectsGodrayFilter'][_0x24d567(0x267)]*(_0x2d26fa-0x1)+_0x564b5f['lacunarity'])/_0x2d26fa,this[_0x24d567(0x25c)][_0x24d567(0x237)]=(this[_0x24d567(0x25c)][_0x24d567(0x237)]*(_0x2d26fa-0x1)+_0x564b5f[_0x24d567(0x237)])/_0x2d26fa),this[_0x24d567(0x25c)]['time']+=this[_0x24d567(0x25c)][_0x24d567(0x26b)],this[_0x24d567(0x25c)]['enabled']=_0x564b5f[_0x24d567(0x234)];}},Spriteset_Base['prototype']['createBrightEffectsColorAdjustFilter']=function(){var _0x2f93e5=_0x344e4d;if(!PIXI[_0x2f93e5(0x26e)][_0x2f93e5(0x1ea)])return;this[_0x2f93e5(0x1f3)]=new PIXI[(_0x2f93e5(0x26e))]['ColorMatrixFilter']();this['brightEffectsBaseOnly']()?this['_baseSprite'][_0x2f93e5(0x26e)][_0x2f93e5(0x256)](this['_BrightEffectsColorAdjustFilter']):this[_0x2f93e5(0x26e)][_0x2f93e5(0x256)](this['_BrightEffectsColorAdjustFilter']);var _0x6de8ba=$gameScreen[_0x2f93e5(0x241)]();_0x6de8ba&&_0x6de8ba[_0x2f93e5(0x252)]>0x0&&(this[_0x2f93e5(0x1f3)][_0x2f93e5(0x20b)]=_0x6de8ba[_0x2f93e5(0x22e)],this[_0x2f93e5(0x1f3)][_0x2f93e5(0x22a)]=_0x6de8ba['contrast'],this[_0x2f93e5(0x1f3)][_0x2f93e5(0x266)]=_0x6de8ba[_0x2f93e5(0x23d)]);},Spriteset_Base[_0x344e4d(0x1fe)][_0x344e4d(0x248)]=function(){var _0x206b8c=_0x344e4d;if(!!this[_0x206b8c(0x1f3)]){var _0x23a9cf=$gameScreen['getBrightEffectsColorAdjustSettings'](),_0x523693=_0x23a9cf[_0x206b8c(0x252)];_0x523693<=0x0?(this[_0x206b8c(0x1f3)]['currentBrightness']=_0x23a9cf[_0x206b8c(0x22e)],this['_BrightEffectsColorAdjustFilter']['currentContrast']=_0x23a9cf[_0x206b8c(0x1e4)],this[_0x206b8c(0x1f3)]['currentSaturate']=_0x23a9cf[_0x206b8c(0x23d)]):(_0x23a9cf[_0x206b8c(0x252)]--,this[_0x206b8c(0x1f3)][_0x206b8c(0x20b)]=(this['_BrightEffectsColorAdjustFilter'][_0x206b8c(0x20b)]*(_0x523693-0x1)+_0x23a9cf[_0x206b8c(0x22e)])/_0x523693,this[_0x206b8c(0x1f3)][_0x206b8c(0x22a)]=(this[_0x206b8c(0x1f3)][_0x206b8c(0x22a)]*(_0x523693-0x1)+_0x23a9cf['contrast'])/_0x523693,this[_0x206b8c(0x1f3)][_0x206b8c(0x266)]=(this['_BrightEffectsColorAdjustFilter'][_0x206b8c(0x266)]*(_0x523693-0x1)+_0x23a9cf['saturate'])/_0x523693),this[_0x206b8c(0x1f3)][_0x206b8c(0x22e)](this[_0x206b8c(0x1f3)][_0x206b8c(0x20b)]),this[_0x206b8c(0x1f3)]['contrast'](this[_0x206b8c(0x1f3)][_0x206b8c(0x22a)],!![]),this[_0x206b8c(0x1f3)]['saturate'](this[_0x206b8c(0x1f3)][_0x206b8c(0x266)],!![]);}},Spriteset_Base[_0x344e4d(0x1fe)]['createBrightEffectsTiltShiftFilter']=function(){var _0x265943=_0x344e4d;if(!PIXI[_0x265943(0x26e)][_0x265943(0x27c)])return;const _0x34f8a8=new PIXI[(_0x265943(0x26e))][(_0x265943(0x27c))]();this[_0x265943(0x265)]=_0x34f8a8;this[_0x265943(0x1e6)]()?this[_0x265943(0x219)][_0x265943(0x26e)][_0x265943(0x256)](_0x34f8a8):this[_0x265943(0x26e)]['push'](_0x34f8a8);var _0x32cd22=$gameScreen[_0x265943(0x270)]();_0x32cd22&&_0x32cd22[_0x265943(0x252)]>0x0&&(_0x34f8a8['currentPixelBlur']=_0x32cd22['pixelBlur'],_0x34f8a8[_0x265943(0x1f4)]=_0x32cd22[_0x265943(0x260)]);},Spriteset_Base[_0x344e4d(0x1fe)][_0x344e4d(0x20a)]=function(){var _0x1dddf7=_0x344e4d;if(!this[_0x1dddf7(0x265)])return;const _0x5940bf=this[_0x1dddf7(0x294)]()+0.5;this[_0x1dddf7(0x26c)](_0x5940bf),this[_0x1dddf7(0x243)]();},Spriteset_Base['prototype'][_0x344e4d(0x26c)]=function(_0x4c3aa3){var _0x47c747=_0x344e4d;const _0x450b30=0x4;if(this[_0x47c747(0x265)][_0x47c747(0x21d)]['y']>_0x4c3aa3)this[_0x47c747(0x265)][_0x47c747(0x21d)]={'x':0x0,'y':Math[_0x47c747(0x227)](this[_0x47c747(0x265)][_0x47c747(0x21d)]['y']-_0x450b30,_0x4c3aa3)},this[_0x47c747(0x265)][_0x47c747(0x1f9)]={'x':0x258,'y':Math[_0x47c747(0x227)](this[_0x47c747(0x265)][_0x47c747(0x1f9)]['y']-_0x450b30,_0x4c3aa3)};else this['_BrightEffectsTiltShiftFilter'][_0x47c747(0x21d)]['y']<_0x4c3aa3&&(this['_BrightEffectsTiltShiftFilter']['start']={'x':0x0,'y':Math[_0x47c747(0x1fc)](this['_BrightEffectsTiltShiftFilter'][_0x47c747(0x21d)]['y']+_0x450b30,_0x4c3aa3)},this['_BrightEffectsTiltShiftFilter']['end']={'x':0x258,'y':Math['min'](this[_0x47c747(0x265)][_0x47c747(0x1f9)]['y']+_0x450b30,_0x4c3aa3)});},Spriteset_Base[_0x344e4d(0x1fe)][_0x344e4d(0x243)]=function(){var _0x36dff0=_0x344e4d;const _0x52bfde=this[_0x36dff0(0x265)];var _0x48a4e0=$gameScreen[_0x36dff0(0x270)](),_0x40d4ee=_0x48a4e0[_0x36dff0(0x252)];_0x40d4ee<=0x0?(_0x52bfde['currentPixelBlur']=_0x48a4e0[_0x36dff0(0x275)],_0x52bfde[_0x36dff0(0x1f4)]=_0x48a4e0['gradientBlur']):(_0x48a4e0[_0x36dff0(0x252)]--,_0x52bfde['currentPixelBlur']=(_0x52bfde[_0x36dff0(0x23b)]*(_0x40d4ee-0x1)+_0x48a4e0[_0x36dff0(0x275)])/_0x40d4ee,_0x52bfde[_0x36dff0(0x1f4)]=(_0x52bfde[_0x36dff0(0x1f4)]*(_0x40d4ee-0x1)+_0x48a4e0['gradientBlur'])/_0x40d4ee),_0x52bfde[_0x36dff0(0x1db)]=_0x52bfde[_0x36dff0(0x23b)],_0x52bfde[_0x36dff0(0x260)]=_0x52bfde['currentGradientBlur'];},Spriteset_Base[_0x344e4d(0x1fe)][_0x344e4d(0x216)]=function(){var _0x2fe9b0=_0x344e4d;const _0x2fa5c0=new PIXI[(_0x2fe9b0(0x26e))]['BlurFilter']();this[_0x2fe9b0(0x220)]=_0x2fa5c0;this[_0x2fe9b0(0x1e6)]()?this[_0x2fe9b0(0x219)][_0x2fe9b0(0x26e)][_0x2fe9b0(0x256)](_0x2fa5c0):this[_0x2fe9b0(0x26e)][_0x2fe9b0(0x256)](_0x2fa5c0);var _0x57c368=$gameScreen[_0x2fe9b0(0x213)]();_0x57c368&&_0x57c368['duration']>0x0&&(_0x2fa5c0[_0x2fe9b0(0x273)]=_0x57c368['blur']);},Spriteset_Base[_0x344e4d(0x1fe)][_0x344e4d(0x25b)]=function(){var _0x9f9ff5=_0x344e4d;if(!!this[_0x9f9ff5(0x220)]){var _0x5be8de=$gameScreen[_0x9f9ff5(0x213)](),_0x3d0ae0=_0x5be8de[_0x9f9ff5(0x252)];_0x3d0ae0<=0x0?this[_0x9f9ff5(0x220)][_0x9f9ff5(0x273)]=_0x5be8de[_0x9f9ff5(0x1db)]:(_0x5be8de[_0x9f9ff5(0x252)]--,this[_0x9f9ff5(0x220)][_0x9f9ff5(0x273)]=(this[_0x9f9ff5(0x220)][_0x9f9ff5(0x273)]*(_0x3d0ae0-0x1)+_0x5be8de[_0x9f9ff5(0x1db)])/_0x3d0ae0),this['_BrightEffectsBlurFilter']['blur']=this[_0x9f9ff5(0x220)][_0x9f9ff5(0x273)];}};